/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.owltable;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.SelectableTable;
import edu.stanford.smi.protege.util.TablePopupMenuMouseListener;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.TripleSelectable;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.code.SymbolCellEditor;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.code.SymbolPanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTableModel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.CellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class SymbolTable
extends SelectableTable
implements TripleSelectable {
    protected OWLTableAction editAnnotationsAction = new AbstractOWLTableAction("Edit Annotation Properties...", OWLIcons.getImageIcon("Annotation")){

        public void actionPerformed(ActionEvent e) {
            SymbolTable.this.editAnnotations();
        }

        public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
            if (cls instanceof OWLAnonymousClass) {
                return cls.isEditable();
            }
            return false;
        }
    };
    protected OWLTableAction editMultiLineAction = new AbstractOWLTableAction("Edit expression in multi-line editor...", Icons.getBlankIcon()){

        public void actionPerformed(ActionEvent e) {
            SymbolTable.this.editMultiLine();
        }

        public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
            if (SymbolTable.this.tableModel.isCellEditable(rowIndex, 0)) {
                return cls != null && cls.isEditable();
            }
            return false;
        }
    };
    public static final int INFINITE_TIME = 1000000;
    private OWLModel owlModel;
    private SymbolCellEditor symbolCellEditor;
    private SymbolEditorComponent symbolEditorComponent;
    private SymbolPanel symbolPanel;
    private SymbolTableModel tableModel;
    private List actions = new ArrayList();
    private boolean withIcon;

    public SymbolTable(SymbolTableModel tableModel, OWLModel owlModel, boolean withIcon, SymbolPanel symbolPanel) {
        this.owlModel = owlModel;
        this.withIcon = withIcon;
        this.symbolPanel = symbolPanel;
        this.tableModel = tableModel;
        this.setRowHeight(Math.max(this.getFontMetrics(this.getFont()).getHeight(), 16));
        this.setModel(tableModel);
        this.setAutoResizeMode(3);
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        this.setRowMargin(0);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.getSelectionModel().setSelectionMode(0);
        this.initSymbolColumn();
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SymbolTable.this.enableActions();
            }
        });
        final int oldDelay = ToolTipManager.sharedInstance().getDismissDelay();
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                ToolTipManager.sharedInstance().setDismissDelay(oldDelay);
            }
        });
        this.addMouseListener((MouseListener)new TablePopupMenuMouseListener((JTable)((Object)this)){

            public JPopupMenu getPopupMenu() {
                return SymbolTable.this.createPopupMenu();
            }

            public void setSelection(JComponent c, int x, int y) {
                if (SymbolTable.this.getSelectedRowCount() > 0) {
                    super.setSelection(c, x, y);
                }
            }
        });
    }

    protected void addNavigationMenuItems(RDFResource resource, JPopupMenu menu) {
        Collection set = this.getNavigationMenuItems(resource);
        if (!set.isEmpty()) {
            Object[] resources = set.toArray(new RDFResource[0]);
            Arrays.sort(resources);
            int i = 0;
            while (i < resources.length) {
                Object targetResource = resources[i];
                menu.add(new AbstractAction("Navigate to " + targetResource.getBrowserText(), ProtegeUI.getIcon((RDFResource)targetResource), (RDFResource)targetResource){
                    private final /* synthetic */ RDFResource val$targetResource;
                    {
                        this.val$targetResource = rDFResource;
                        super($anonymous0, $anonymous1);
                    }

                    public void actionPerformed(ActionEvent e) {
                        SymbolTable.this.navigateTo(this.val$targetResource);
                    }
                });
                ++i;
            }
        }
    }

    public SymbolEditorComponent getSymbolEditorComponent() {
        return this.symbolEditorComponent;
    }

    protected abstract Collection getNavigationMenuItems(RDFResource var1);

    protected void configureEnclosingScrollPane() {
        if (this.isTableHeaderHidden()) {
            Container gp;
            Container p = this.getParent();
            if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)gp;
                JViewport viewport = scrollPane.getViewport();
                if (viewport == null || viewport.getView() != this) {
                    return;
                }
                scrollPane.getViewport().setScrollMode(2);
                scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
        } else {
            super.configureEnclosingScrollPane();
        }
    }

    protected ResourceRenderer createOWLFrameRenderer() {
        return new ResourceRenderer();
    }

    protected JPopupMenu createPopupMenu() {
        RDFResource selectedInstance = this.getSelectedOWLInstance();
        JPopupMenu menu = new JPopupMenu();
        if (selectedInstance != null) {
            this.addNavigationMenuItems(selectedInstance, menu);
        }
        Iterator it = this.actions.iterator();
        while (it.hasNext()) {
            OWLTableAction action = (OWLTableAction)it.next();
            if (action == null) {
                if (!it.hasNext()) continue;
                menu.addSeparator();
                continue;
            }
            menu.add(action);
        }
        if (selectedInstance != null) {
            ResourceActionManager.addResourceActions(menu, (Component)((Object)this), selectedInstance);
        }
        if (menu.getComponentCount() > 0) {
            return menu;
        }
        return null;
    }

    protected abstract SymbolEditorComponent createSymbolEditorComponent(OWLModel var1, SymbolErrorDisplay var2);

    protected void editAnnotations() {
        RDFResource selectedInstance = this.getSelectedOWLInstance();
        selectedInstance.getProject().show((Instance)selectedInstance);
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        boolean result = super.editCellAt(row, column, e);
        if (column == this.tableModel.getSymbolColumnIndex()) {
            this.symbolEditorComponent.getTextComponent().requestFocus();
            if (e instanceof MouseEvent) {
                int mouseX = ((MouseEvent)e).getX();
                if (this.withIcon) {
                    mouseX -= this.symbolEditorComponent.getX();
                }
                String str = this.symbolEditorComponent.getTextComponent().getText();
                FontMetrics fm = this.symbolEditorComponent.getTextComponent().getFontMetrics(this.symbolEditorComponent.getTextComponent().getFont());
                int index = 1;
                while (index < str.length()) {
                    if (fm.stringWidth(str.substring(0, index)) >= mouseX) {
                        this.symbolEditorComponent.getTextComponent().setCaretPosition(index - 1);
                        break;
                    }
                    ++index;
                }
            }
        }
        return result;
    }

    public void editExpression(int row) {
        int owlColumn = this.tableModel.getSymbolColumnIndex();
        this.getSelectionModel().setSelectionInterval(row, row);
        this.scrollRectToVisible(this.getCellRect(row, 0, true));
        this.editCellAt(row, owlColumn);
        this.symbolEditorComponent.getTextComponent().requestFocus();
    }

    protected void editMultiLine() {
        RDFResource input = this.getSelectedOWLInstance();
        String newExpression = this.editMultiLine(input);
        if (newExpression != null) {
            this.tableModel.setValueAt(newExpression, this.getSelectedRow(), this.tableModel.getSymbolColumnIndex());
        }
    }

    protected abstract String editMultiLine(RDFResource var1);

    public void enableActions() {
        this.enableActions(this.actions);
    }

    protected void enableActions(Collection actions) {
    }

    public Clipboard getClipboard() {
        return this.getToolkit().getSystemClipboard();
    }

    public Dimension getPreferredSize() {
        Dimension s = super.getPreferredSize();
        int h = this.getRowHeight();
        return new Dimension(s.width, Math.max(h, s.height));
    }

    public ResourceRenderer getOWLFrameRenderer() {
        TableColumn owlColumn = this.getColumnModel().getColumn(this.tableModel.getSymbolColumnIndex());
        return (ResourceRenderer)((Object)owlColumn.getCellRenderer());
    }

    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    private JLayeredPane getParentLayeredPane() {
        Container c = this.getParent();
        while (c != null && !(c instanceof JLayeredPane)) {
            c = c.getParent();
        }
        return (JLayeredPane)c;
    }

    public List getPrototypeTriples() {
        int[] sels = this.getSelectedRows();
        if (sels.length == 0) {
            RDFResource subject = this.tableModel.getSubject();
            RDFProperty predicate = this.tableModel.getPredicate(-1);
            if (subject != null && predicate != null) {
                return Collections.singletonList(new DefaultTriple(subject, predicate, null));
            }
            return Collections.EMPTY_LIST;
        }
        Triple triple = (Triple)this.getSelectedTriples().get(0);
        return Collections.singletonList(new DefaultTriple(triple.getSubject(), triple.getPredicate(), null));
    }

    public RDFResource getSelectedResource() {
        int index = this.getSelectedRow();
        if (index >= 0 && index < this.tableModel.getRowCount()) {
            return this.tableModel.getRDFResource(index);
        }
        return null;
    }

    public int[] getSelectedRows() {
        int[] sels = super.getSelectedRows();
        ArrayList<Integer> oks = new ArrayList<Integer>();
        int i = 0;
        while (i < sels.length) {
            int sel = sels[i];
            if (sel >= 0 && sel < this.tableModel.getRowCount()) {
                oks.add(new Integer(sel));
            }
            ++i;
        }
        int[] result = new int[oks.size()];
        Iterator it = oks.iterator();
        int i2 = 0;
        while (it.hasNext()) {
            Integer integer = (Integer)it.next();
            result[i2] = integer;
            ++i2;
        }
        return result;
    }

    public RDFResource getSelectedOWLInstance() {
        return this.getSelectedResource();
    }

    public List getSelectedTriples() {
        int[] sels = this.getSelectedRows();
        if (sels.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DefaultTriple> result = new ArrayList<DefaultTriple>();
        RDFResource subject = this.tableModel.getSubject();
        if (subject != null) {
            int i = 0;
            while (i < sels.length) {
                int row = sels[i];
                if (row >= 0 && row < this.tableModel.getRowCount()) {
                    RDFProperty predicate = this.tableModel.getPredicate(row);
                    RDFResource object = this.tableModel.getRDFResource(row);
                    if (predicate != null && object != null) {
                        result.add(new DefaultTriple(subject, predicate, object));
                    }
                }
                ++i;
            }
        }
        return result;
    }

    protected CellEditor getSymbolCellEditor() {
        return this.symbolCellEditor;
    }

    protected SymbolPanel getSymbolPanel() {
        return this.symbolPanel;
    }

    protected SymbolTableModel getSymbolTableModel() {
        return this.tableModel;
    }

    public String getToolTipText(MouseEvent event) {
        ToolTipManager.sharedInstance().setDismissDelay(1000000);
        int rowCount = this.getModel().getRowCount();
        int i = 0;
        while (i < rowCount) {
            Rectangle r = this.getCellRect(i, 0, false);
            r.setSize(this.getWidth(), r.height);
            if (r.contains(event.getPoint())) {
                RDFResource RDFResource2 = this.tableModel.getRDFResource(i);
                return this.getToolTipText(RDFResource2);
            }
            ++i;
        }
        return null;
    }

    protected abstract String getToolTipText(RDFResource var1);

    public void hideSymbolPanel() {
        Container parent;
        if (this.symbolPanel != null && (parent = this.symbolPanel.getParent()) != null) {
            parent.remove(this.symbolPanel);
            Container top = this.getTopLevelAncestor();
            if (top instanceof JFrame) {
                ((JFrame)top).getContentPane().repaint();
            } else if (top instanceof JWindow) {
                ((JWindow)top).getContentPane().repaint();
            } else if (top instanceof JDialog) {
                ((JDialog)top).getContentPane().repaint();
            } else {
                ProjectView projectView = ProtegeUI.getProjectView(this.getOWLModel().getProject());
                projectView.getTabbedPane().repaint();
            }
        }
    }

    protected int getPreferredRowHeight(JTable table, SymbolEditorComponent editorComponent) {
        return this.getRowHeight();
    }

    private void initSymbolColumn() {
        int owlColumnIndex = this.tableModel.getSymbolColumnIndex();
        TableColumn owlColumn = this.getColumnModel().getColumn(owlColumnIndex);
        this.symbolEditorComponent = this.createSymbolEditorComponent(this.owlModel, this.symbolPanel);
        this.symbolPanel.setSymbolEditor(this.symbolEditorComponent);
        this.symbolCellEditor = new SymbolCellEditor(this.symbolEditorComponent){

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                table.setRowHeight(row, SymbolTable.this.getPreferredRowHeight(table, SymbolTable.this.symbolEditorComponent));
                if (SymbolTable.this.withIcon) {
                    JPanel result = new JPanel(new BorderLayout(1, 0));
                    result.setOpaque(false);
                    result.add("Center", c);
                    RDFResource resource = SymbolTable.this.tableModel.getRDFResource(row);
                    Icon icon = SymbolTable.this.getIcon(resource);
                    result.add("West", new JLabel(icon));
                    return result;
                }
                return c;
            }
        };
        this.symbolEditorComponent.setSymbolEditorHandler(this.symbolCellEditor);
        this.symbolCellEditor.addCellEditorListener(new CellEditorListener(){

            public void editingCanceled(ChangeEvent e) {
                SymbolTable.this.hideSymbolPanel();
            }

            public void editingStopped(ChangeEvent e) {
                SymbolTable.this.hideSymbolPanel();
            }
        });
        this.initSymbolColumnRenderer();
    }

    protected Icon getIcon(RDFResource resource) {
        Icon icon = null;
        icon = resource == null ? this.getDefaultCellEditorIcon(resource) : this.tableModel.getIcon(resource);
        return icon;
    }

    protected Icon getDefaultCellEditorIcon(RDFResource RDFResource2) {
        return OWLIcons.getPrimitiveClsIcon();
    }

    private void initSymbolColumnRenderer() {
        if (this.tableModel != null) {
            int owlColumnIndex = this.tableModel.getSymbolColumnIndex();
            TableColumn owlColumn = this.getColumnModel().getColumn(owlColumnIndex);
            if (this.withIcon) {
                ResourceRenderer renderer = this.createOWLFrameRenderer();
                renderer.setDisplayHiddenIcon(false);
                owlColumn.setCellRenderer((TableCellRenderer)((Object)renderer));
            }
            owlColumn.setCellEditor(this.symbolCellEditor);
        }
    }

    protected boolean isTableHeaderHidden() {
        return this.getModel().getColumnCount() == 1;
    }

    protected void navigateTo(RDFResource resource) {
        ResultsPanelManager.showHostResource(resource);
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component c = super.prepareEditor(editor, row, column);
        if (column == this.tableModel.getSymbolColumnIndex()) {
            Object value = this.getModel().getValueAt(row, column);
            String expression = value instanceof RDFResource ? ((RDFResource)value).getBrowserText() : (String)value;
            this.showSymbolPanel(expression.length() == 0);
        }
        return c;
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        if (column == this.tableModel.getSymbolColumnIndex() && renderer instanceof FrameRenderer) {
            RDFResource RDFResource2 = this.tableModel.getRDFResource(row);
            boolean isSelected = this.isCellSelected(row, column);
            boolean rowIsAnchor = this.selectionModel.getAnchorSelectionIndex() == row;
            boolean colIsAnchor = this.columnModel.getSelectionModel().getAnchorSelectionIndex() == column;
            boolean hasFocus = rowIsAnchor && colIsAnchor && this.isFocusOwner();
            return renderer.getTableCellRendererComponent((JTable)((Object)this), RDFResource2, isSelected, hasFocus, row, column);
        }
        return super.prepareRenderer(renderer, row, column);
    }

    public void registerAction(OWLTableAction action) {
        this.actions.add(action);
        action.setEnabled(false);
    }

    public void registerAction(OWLTableAction action, int index) {
        this.actions.add(index, action);
        action.setEnabled(false);
    }

    public void registerActionSeparator() {
        this.actions.add(null);
    }

    public void setModel(TableModel newModel) {
        TableModel oldModel = this.getModel();
        if (oldModel instanceof Disposable) {
            ((Disposable)oldModel).dispose();
        }
        super.setModel(newModel);
        if (newModel instanceof SymbolTableModel) {
            this.tableModel = (SymbolTableModel)newModel;
        }
        this.initSymbolColumnRenderer();
    }

    public void setSelectedRow(RDFResource resource) {
        String browserText = resource.getBrowserText();
        this.setSelectedRow(browserText);
    }

    public void setSelectedRow(String browserText) {
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            RDFResource rowCls = this.tableModel.getRDFResource(i);
            if (rowCls != null && browserText.equals(rowCls.getBrowserText())) {
                this.getSelectionModel().setSelectionInterval(i, i);
            }
            ++i;
        }
    }

    public void setSelectedRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.tableModel.getRowCount()) {
            this.getSelectionModel().clearSelection();
        } else {
            this.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
        }
    }

    public void setSelectedTriples(Collection triples) {
        this.getSelectionModel().clearSelection();
        block0: for (Triple triple : triples) {
            int i = 0;
            while (i < this.tableModel.getRowCount()) {
                if (triple.getObject().equals(this.tableModel.getRDFResource(i))) {
                    this.getSelectionModel().addSelectionInterval(i, i);
                    continue block0;
                }
                ++i;
            }
        }
    }

    protected void showSymbolPanel(boolean errorFlag) {
        int y;
        JLayeredPane desktop = this.getParentLayeredPane();
        int owlColumn = this.tableModel.getSymbolColumnIndex();
        Rectangle r = this.getCellRect(this.getSelectedRow(), owlColumn, true);
        Point tableLocation = this.getLocationOnScreen();
        Point desktopLocation = desktop.getLocationOnScreen();
        r.translate(tableLocation.x - desktopLocation.x, tableLocation.y - desktopLocation.y);
        Dimension pref = this.symbolPanel.getPreferredSize();
        int x = this.getX() + r.x;
        if (pref.width > r.width) {
            x = Math.max(0, this.getX() + r.x - (pref.width - r.width));
        }
        if ((y = r.y + r.height + 4) + this.symbolPanel.getHeight() >= desktop.getHeight()) {
            y = r.y - this.symbolPanel.getHeight();
        }
        this.symbolPanel.setLocation(x, y);
        this.symbolPanel.displayError((Throwable)null);
        this.symbolPanel.setErrorFlag(errorFlag);
        this.symbolPanel.enableActions(true, true);
        desktop.setLayer(this.symbolPanel, JLayeredPane.POPUP_LAYER);
        desktop.add(this.symbolPanel);
    }
}

