/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.PropertyMapUtil;
import edu.stanford.smi.protege.test.APITestCase;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class PropertyMapUtil_Test
extends APITestCase {
    protected Instance _mapInstance;

    public void setUp() throws Exception {
        super.setUp();
        KnowledgeBase knowledgeBase = this.getProject().getSources().getWrappedInstance().getKnowledgeBase();
        Cls cls = knowledgeBase.getCls("Map");
        this._mapInstance = knowledgeBase.createInstance(null, cls);
    }

    public void testClassObject() {
        Map map = new HashMap<Object, Object>();
        map.put("foo", PropertyMapUtil_Test.class);
        map.put(PropertyMapUtil.class, "bar");
        map.put(Project.class, Model.class);
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        PropertyMapUtil_Test.assertSame((String)"string to class", PropertyMapUtil_Test.class, map.get("foo"));
        PropertyMapUtil_Test.assertEquals((String)"class to string", (Object)"bar", map.get(PropertyMapUtil.class));
        PropertyMapUtil_Test.assertSame((String)"class to class", Model.class, map.get(Project.class));
    }

    public void testFrame() {
        Frame frame = this.createFrame();
        Frame frame2 = this.createFrame();
        Frame frame3 = this.createFrame();
        Frame frame4 = this.createFrame();
        Map map = new HashMap<Object, Object>();
        map.put(frame, "foo");
        map.put("bar", frame2);
        map.put(frame3, frame4);
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        PropertyMapUtil_Test.assertSame((String)"frame to frame", (Object)frame4, map.get(frame3));
        PropertyMapUtil_Test.assertEquals((String)"string to frame", (Object)"foo", map.get(frame));
        PropertyMapUtil_Test.assertSame((String)"frame to string", (Object)frame2, map.get("bar"));
    }

    public void testInteger() {
        Map map = new HashMap<Object, Object>();
        map.put(new Integer(1), "foo1");
        map.put("foo2", new Integer(2));
        map.put(new Integer(3), new Integer(4));
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        PropertyMapUtil_Test.assertEquals((String)"int to string", (Object)"foo1", map.get(new Integer(1)));
        PropertyMapUtil_Test.assertEquals((String)"string to int", (Object)new Integer(2), map.get("foo2"));
        PropertyMapUtil_Test.assertEquals((String)"int to int", (Object)new Integer(4), map.get(new Integer(3)));
    }

    public void testJavaClass() {
        TestClass testClass = new TestClass("a");
        TestClass testClass2 = new TestClass("b");
        TestClass testClass3 = new TestClass("c");
        TestClass testClass4 = new TestClass("d");
        Map map = new HashMap<Object, Object>();
        map.put(testClass, "foo");
        map.put("bar", testClass2);
        map.put(testClass3, testClass4);
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        PropertyMapUtil_Test.assertEquals((String)"object to string", (Object)"foo", map.get(testClass));
        PropertyMapUtil_Test.assertEquals((String)"string to object", (Object)testClass2, map.get("bar"));
        PropertyMapUtil_Test.assertEquals((String)"object to object", (Object)testClass4, map.get(testClass3));
    }

    public void testMap() {
        Map map = new HashMap();
        Map map2 = new HashMap<String, String>();
        map2.put("foo", "bar");
        map.put("submap1", map2);
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        map2 = (Map)map.get("submap1");
        PropertyMapUtil_Test.assertNotNull((String)"submap", map2);
        PropertyMapUtil_Test.assertEquals((Object)"bar", map2.get("foo"));
    }

    public void testRectangle() {
        Rectangle rectangle = new Rectangle(1, 2, 3, 4);
        Rectangle rectangle2 = new Rectangle(5, 6, 7, 8);
        Rectangle rectangle3 = new Rectangle(10, 20, 30, 40);
        Rectangle rectangle4 = new Rectangle(50, 60, 70, 80);
        Map map = new HashMap<Object, Object>();
        map.put(rectangle, "foo1");
        map.put("foo2", rectangle2);
        map.put(rectangle3, rectangle4);
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        PropertyMapUtil_Test.assertEquals((String)"rect to string", (Object)"foo1", map.get(rectangle));
        PropertyMapUtil_Test.assertEquals((String)"string to rect", (Object)rectangle2, map.get("foo2"));
        PropertyMapUtil_Test.assertEquals((String)"rect to rect", (Object)rectangle4, map.get(rectangle3));
    }

    public void testString() {
        Map map = new HashMap<String, String>();
        map.put("foo", "bar");
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        PropertyMapUtil_Test.assertEquals((String)"string to string", (Object)"bar", map.get("foo"));
    }

    public static class TestClass {
        String _value;

        public TestClass(String string) {
            this._value = string;
        }

        public String toString() {
            return this._value;
        }

        public boolean equals(Object object) {
            TestClass testClass = (TestClass)object;
            return this._value.equals(testClass._value);
        }

        public int hashCode() {
            return this._value.hashCode();
        }
    }
}

