/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.Locator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocatorFile
implements Locator {
    static Log log = LogFactory.getLog((Class)LocatorFile.class);
    private String altDir = null;
    private String altDirLogStr = "";

    LocatorFile(String string) {
        if (string != null) {
            if (string.endsWith("/") || string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - 1);
            }
            this.altDirLogStr = " [" + string + "]";
        }
        this.altDir = string;
    }

    LocatorFile() {
        this(null);
    }

    private File toFile(String string) {
        String string2 = FileUtils.toFilename(string);
        if (string2 == null) {
            return null;
        }
        if (this.altDir != null && !string2.startsWith("/") && !string2.startsWith(FileManager.filePathSeparator)) {
            string2 = this.altDir + File.separator + string2;
        }
        return new File(string2);
    }

    public boolean exists(String string) {
        File file = this.toFile(string);
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public InputStream open(String string) {
        File file = this.toFile(string);
        if (file == null || !file.exists()) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("Not found: " + string + this.altDirLogStr));
            }
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            if (fileInputStream == null) {
                if (FileManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace((Object)("LocatorFile: Failed to open: " + string + this.altDirLogStr));
                }
                return null;
            }
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("Found: " + string + this.altDirLogStr));
            }
            return fileInputStream;
        }
        catch (IOException iOException) {
            log.warn((Object)("File unreadable (but exists): " + file.getPath() + " Exception: " + iOException.getMessage()));
            return null;
        }
    }

    public String getName() {
        String string = "LocatorFile";
        if (this.altDir != null) {
            string = string + "(" + this.altDir + ")";
        }
        return string;
    }
}

