/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator.tests;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.stanford.smi.protegex.owl.jena.creator.tests.AbstractJenaCreatorTestCase;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import java.util.Iterator;

public class CreateAnonymousResourcesTestCase
extends AbstractJenaCreatorTestCase {
    public void testCreatePseudoList() {
        OWLNamedClass listCls = this.owlModel.createOWLNamedClass("List");
        OWLObjectProperty restSlot = this.owlModel.createOWLObjectProperty("rest");
        restSlot.addUnionDomainClass(listCls);
        RDFResource rootNode = listCls.createInstance("Root");
        RDFResource middleNode = listCls.createAnonymousInstance();
        rootNode.setPropertyValue(restSlot, middleNode);
        RDFResource leafNode = listCls.createAnonymousInstance();
        middleNode.setPropertyValue(restSlot, leafNode);
        OntModel newModel = this.runJenaCreator();
        Individual rootIndividual = newModel.getIndividual(rootNode.getURI());
        CreateAnonymousResourcesTestCase.assertFalse((boolean)rootIndividual.isAnon());
        OntProperty restProperty = newModel.getOntProperty(restSlot.getURI());
        Individual middleIndividual = (Individual)rootIndividual.getPropertyValue((Property)restProperty).as(Individual.class);
        CreateAnonymousResourcesTestCase.assertTrue((boolean)middleIndividual.isAnon());
        OntClass listClass = newModel.getOntClass(listCls.getURI());
        CreateAnonymousResourcesTestCase.assertSize(3, (Iterator)newModel.listStatements(null, RDF.type, (RDFNode)listClass));
    }
}

