/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins;

import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.LiteralInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentNumberException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.LiteralConversionException;
import java.util.List;

public class SWRLBuiltInUtil {
    public static boolean isExpectingAssignment(String builtInName, List arguments) {
        return !arguments.isEmpty() && arguments.get(0) == null;
    }

    public static void checkNumberOfArgumentsEqualTo(String builtInName, int expecting, int actual) throws InvalidBuiltInArgumentNumberException {
        if (expecting != actual) {
            throw new InvalidBuiltInArgumentNumberException(builtInName, expecting, actual);
        }
    }

    public static void checkNumberOfArgumentsAtLeast(String builtInName, int expectingAtLeast, int actual) throws InvalidBuiltInArgumentNumberException {
        if (actual < expectingAtLeast) {
            throw new InvalidBuiltInArgumentNumberException(builtInName, expectingAtLeast, actual, "at least");
        }
    }

    public static void checkNumberOfArgumentsAtMost(String builtInName, int expectingAtMost, int actual) throws InvalidBuiltInArgumentNumberException {
        if (actual > expectingAtMost) {
            throw new InvalidBuiltInArgumentNumberException(builtInName, expectingAtMost, actual, "at most");
        }
    }

    public static void checkThatAllArgumentsAreLiterals(String builtInName, List arguments) throws InvalidBuiltInArgumentException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            SWRLBuiltInUtil.checkThatArgumentIsALiteral(builtInName, argumentNumber, arguments);
            ++argumentNumber;
        }
    }

    public static void checkThatAllArgumentsAreNumeric(String builtInName, List arguments) throws InvalidBuiltInArgumentException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            SWRLBuiltInUtil.checkThatArgumentIsNumeric(builtInName, argumentNumber, arguments);
            ++argumentNumber;
        }
    }

    public static void checkThatAllArgumentsAreIntegers(String builtInName, List arguments) throws InvalidBuiltInArgumentException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            SWRLBuiltInUtil.checkThatArgumentIsAnInteger(builtInName, argumentNumber, arguments);
            ++argumentNumber;
        }
    }

    public static boolean areAllArgumentsIntegers(String builtInName, List arguments) throws InvalidBuiltInArgumentException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            if (!SWRLBuiltInUtil.isArgumentAnInteger(argumentNumber, arguments)) {
                return false;
            }
            ++argumentNumber;
        }
        return true;
    }

    public static boolean areAllArgumentsLongs(String builtInName, List arguments) throws InvalidBuiltInArgumentException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            if (!SWRLBuiltInUtil.isArgumentALong(argumentNumber, arguments)) {
                return false;
            }
            ++argumentNumber;
        }
        return true;
    }

    public static boolean areAllArgumentsDoubles(String builtInName, List arguments) throws InvalidBuiltInArgumentException, LiteralConversionException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            if (!SWRLBuiltInUtil.isArgumentADouble(argumentNumber, arguments)) {
                return false;
            }
            ++argumentNumber;
        }
        return true;
    }

    public static boolean areAllArgumentsBooleans(String builtInName, List arguments) throws InvalidBuiltInArgumentException, LiteralConversionException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            if (!SWRLBuiltInUtil.isArgumentABoolean(argumentNumber, arguments)) {
                return false;
            }
            ++argumentNumber;
        }
        return true;
    }

    public static boolean areAllArgumentLiterals(String builtInName, List arguments) throws InvalidBuiltInArgumentException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            if (!SWRLBuiltInUtil.isArgumentALiteral(argumentNumber, arguments)) {
                return false;
            }
            ++argumentNumber;
        }
        return true;
    }

    public static boolean areAllArgumentsFloats(String builtInName, List arguments) throws InvalidBuiltInArgumentException, LiteralConversionException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            if (!SWRLBuiltInUtil.isArgumentAFloat(argumentNumber, arguments)) {
                return false;
            }
            ++argumentNumber;
        }
        return true;
    }

    public static boolean areAllArgumentsNumeric(String builtInName, List arguments) throws InvalidBuiltInArgumentException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            if (!SWRLBuiltInUtil.isArgumentNumeric(argumentNumber, arguments)) {
                return false;
            }
            ++argumentNumber;
        }
        return true;
    }

    public static boolean areAllArgumentsStrings(String builtInName, List arguments) throws InvalidBuiltInArgumentException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            if (!SWRLBuiltInUtil.isArgumentAString(argumentNumber, arguments)) {
                return false;
            }
            ++argumentNumber;
        }
        return true;
    }

    public static boolean areAllArgumentsOfAnOrderedType(String builtInName, List arguments) throws InvalidBuiltInArgumentException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            if (!SWRLBuiltInUtil.isArgumentOfAnOrderedType(argumentNumber, arguments)) {
                return false;
            }
            ++argumentNumber;
        }
        return true;
    }

    public static void checkThatAllArgumentsAreFloats(String builtInName, List arguments) throws InvalidBuiltInArgumentException, LiteralConversionException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            SWRLBuiltInUtil.checkThatArgumentIsAFloat(builtInName, argumentNumber, arguments);
            ++argumentNumber;
        }
    }

    public static void checkThatAllArgumentsAreStrings(String builtInName, List arguments) throws InvalidBuiltInArgumentException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            SWRLBuiltInUtil.checkThatArgumentIsAString(builtInName, argumentNumber, arguments);
            ++argumentNumber;
        }
    }

    public static void checkThatAllArgumentsAreOfAnOrderedType(String builtInName, List arguments) throws InvalidBuiltInArgumentException {
        int argumentNumber = 0;
        while (argumentNumber < arguments.size()) {
            SWRLBuiltInUtil.checkThatArgumentIsOfAnOrderedType(builtInName, argumentNumber, arguments);
            ++argumentNumber;
        }
    }

    public static void checkThatArgumentIsALiteral(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (!(arguments.get(argumentNumber) instanceof LiteralInfo)) {
            throw new InvalidBuiltInArgumentException(builtInName, argumentNumber, "Expecting literal");
        }
    }

    public static void checkThatArgumentIsNumeric(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentNumeric(argumentNumber, arguments)) {
            throw new InvalidBuiltInArgumentException(builtInName, argumentNumber, "Expecting numeric literal");
        }
    }

    public static void checkThatArgumentIsOfAnOrderedType(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentOfAnOrderedType(argumentNumber, arguments)) {
            throw new InvalidBuiltInArgumentException(builtInName, argumentNumber, "Expecting ordered type");
        }
    }

    public static boolean isArgumentOfAnOrderedType(int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        return SWRLBuiltInUtil.isArgumentNumeric(argumentNumber, arguments) || SWRLBuiltInUtil.isArgumentAString(argumentNumber, arguments);
    }

    public static void checkThatArgumentIsAnIndividualName(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (!(arguments.get(argumentNumber) instanceof IndividualInfo)) {
            throw new InvalidBuiltInArgumentException(builtInName, argumentNumber, "Expecting individual name");
        }
    }

    public static boolean isArgumentNumeric(int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (SWRLBuiltInUtil.isArgumentALiteral(argumentNumber, arguments)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).isNumeric();
        }
        return false;
    }

    public static boolean isArgumentNonNumeric(int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (SWRLBuiltInUtil.isArgumentALiteral(argumentNumber, arguments)) {
            return !SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).isNumeric();
        }
        return false;
    }

    public static void checkThatArgumentIsNonNumeric(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentNonNumeric(argumentNumber, arguments)) {
            throw new InvalidBuiltInArgumentException(builtInName, argumentNumber, "Expecting non-numeric literal");
        }
    }

    public static void checkThatArgumentIsAnInteger(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentAnInteger(argumentNumber, arguments)) {
            throw new InvalidBuiltInArgumentException(builtInName, argumentNumber, "Expecting integer literal");
        }
    }

    public static boolean isArgumentAnInteger(int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (SWRLBuiltInUtil.isArgumentALiteral(argumentNumber, arguments)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).isInteger();
        }
        return false;
    }

    public static int getArgumentAsAnInteger(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException, LiteralConversionException {
        SWRLBuiltInUtil.checkThatArgumentIsAnInteger(builtInName, argumentNumber, arguments);
        return SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).getInt();
    }

    public static boolean isArgumentALiteral(int argumentNumber, List arguments) {
        return arguments.get(argumentNumber) instanceof LiteralInfo;
    }

    public static LiteralInfo getArgumentAsALiteral(int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        return (LiteralInfo)arguments.get(argumentNumber);
    }

    public static void checkThatArgumentIsALong(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentALong(argumentNumber, arguments)) {
            throw new InvalidBuiltInArgumentException(builtInName, argumentNumber, "Expecting long literal");
        }
    }

    public static boolean isArgumentALong(int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (SWRLBuiltInUtil.isArgumentALiteral(argumentNumber, arguments)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).isLong();
        }
        return false;
    }

    public static long getArgumentAsALong(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException, LiteralConversionException {
        SWRLBuiltInUtil.checkThatArgumentIsALong(builtInName, argumentNumber, arguments);
        return SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).getLong();
    }

    public static void checkThatArgumentIsAFloat(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException, LiteralConversionException {
        if (!SWRLBuiltInUtil.isArgumentAFloat(argumentNumber, arguments)) {
            throw new InvalidBuiltInArgumentException(builtInName, argumentNumber, "Expecting float literal");
        }
    }

    public static boolean isArgumentAFloat(int argumentNumber, List arguments) throws InvalidBuiltInArgumentException, LiteralConversionException {
        if (SWRLBuiltInUtil.isArgumentALiteral(argumentNumber, arguments)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).isFloat();
        }
        return false;
    }

    public static float getArgumentAsAFloat(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException, LiteralConversionException {
        SWRLBuiltInUtil.checkThatArgumentIsAFloat(builtInName, argumentNumber, arguments);
        return SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).getFloat();
    }

    public static void checkThatArgumentIsADouble(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException, LiteralConversionException {
        if (!SWRLBuiltInUtil.isArgumentADouble(argumentNumber, arguments)) {
            throw new InvalidBuiltInArgumentException(builtInName, argumentNumber, "Expecting float literal");
        }
    }

    public static boolean isArgumentADouble(int argumentNumber, List arguments) throws InvalidBuiltInArgumentException, LiteralConversionException {
        if (SWRLBuiltInUtil.isArgumentALiteral(argumentNumber, arguments)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).isDouble();
        }
        return false;
    }

    public static double getArgumentAsADouble(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException, LiteralConversionException {
        SWRLBuiltInUtil.checkThatArgumentIsADouble(builtInName, argumentNumber, arguments);
        return SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).getDouble();
    }

    public static void checkThatArgumentIsABoolean(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentABoolean(argumentNumber, arguments)) {
            throw new InvalidBuiltInArgumentException(builtInName, argumentNumber, "Expecting boolean literal");
        }
    }

    public static boolean isArgumentABoolean(int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (SWRLBuiltInUtil.isArgumentALiteral(argumentNumber, arguments)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).isBoolean();
        }
        return false;
    }

    public static boolean getArgumentAsABoolean(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        SWRLBuiltInUtil.checkThatArgumentIsABoolean(builtInName, argumentNumber, arguments);
        return SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).getBoolean();
    }

    public static void checkThatArgumentIsAString(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentAString(argumentNumber, arguments)) {
            throw new InvalidBuiltInArgumentException(builtInName, argumentNumber, "Expecting string literal");
        }
    }

    public static boolean isArgumentAString(int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        if (SWRLBuiltInUtil.isArgumentALiteral(argumentNumber, arguments)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).isString();
        }
        return false;
    }

    public static String getArgumentAsAString(String builtInName, int argumentNumber, List arguments) throws InvalidBuiltInArgumentException {
        SWRLBuiltInUtil.checkThatArgumentIsAString(builtInName, argumentNumber, arguments);
        return SWRLBuiltInUtil.getArgumentAsALiteral(argumentNumber, arguments).getString();
    }
}

