/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.profiles;

import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import edu.stanford.smi.protegex.owl.model.project.SettingsMap;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ProfilesManager {
    private static Map customOntModelCache = new HashMap();
    private static OntModel defaultOntModel;
    private static Map featuresCache;
    public static final String CUSTOM_PROFILE_KEY = "OWL-CUSTOM-PROFILE-URI";
    public static final String PREDEFINED_PROFILE_URI_KEY = "OWL-PREDEFINED-PROFILE-URI";

    static {
        featuresCache = new HashMap();
    }

    public static void addAltEntryForOWLProfiles(OntModel ontModel) {
        String applDir = ApplicationProperties.getApplicationDirectory().getAbsolutePath();
        String altEntry = new File(ProtegeOWL.getPluginFolder(), "OWLProfiles.owl").toURI().toString();
        String ns = "http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#";
        ontModel.getDocumentManager().addAltEntry(ns, altEntry);
        ns = ns.substring(0, ns.length() - 1);
        ontModel.getDocumentManager().addAltEntry(ns, altEntry);
    }

    public static void clearCache(String uri) {
        customOntModelCache.remove(uri);
        featuresCache.remove(uri);
    }

    public static OntModel createProfile(String defaultNamespace) {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.setNsPrefix("", defaultNamespace);
        ProfilesManager.addAltEntryForOWLProfiles(ontModel);
        String partialNamespace = defaultNamespace.substring(0, defaultNamespace.length() - 1);
        Ontology ontology = ontModel.createOntology(partialNamespace);
        ontology.addImport(ontModel.getResource("http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#"));
        return ontModel;
    }

    public static OntClass getCustomProfileFeaturesClass(OntModel ontModel) {
        StmtIterator it = ontModel.getBaseModel().listStatements(null, RDF.type, (RDFNode)OWL.Class);
        if (it.hasNext()) {
            Resource subject = it.nextStatement().getSubject();
            return ontModel.getOntClass(subject.getURI());
        }
        return null;
    }

    private static OntModel getCustomProfileOntModel(String uri) throws Exception {
        OntModel ontModel = (OntModel)customOntModelCache.get(uri);
        if (ontModel == null) {
            ontModel = ModelFactory.createOntologyModel();
            ProfilesManager.addAltEntryForOWLProfiles(ontModel);
            if (uri.startsWith("http://")) {
                ontModel.read(uri, "RDF/XML-ABBREV");
            } else {
                ontModel.read((InputStream)new FileInputStream(uri), "http://dummy.de/ontology#", "RDF/XML-ABBREV");
            }
            customOntModelCache.put(uri, ontModel);
        }
        return ontModel;
    }

    public static String getCustomProfileURI(OWLModel owlModel) {
        return owlModel.getOWLProject().getSettingsMap().getString(CUSTOM_PROFILE_KEY);
    }

    public static OntModel getDefaultProfileOntModel() {
        if (defaultOntModel == null) {
            defaultOntModel = ModelFactory.createOntologyModel();
            ProfilesManager.addAltEntryForOWLProfiles(defaultOntModel);
            String ns = "http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#";
            ns = ns.substring(0, ns.length() - 1);
            defaultOntModel.read(ns, "RDF/XML-ABBREV");
            if (defaultOntModel.getOntClass(OWLProfiles.OWL_Full.getURI()) == null) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog((OWLModel)null, "Could not open default OWL Profiles file.\nPlease make sure that the OWLProfiles.owl file\ncan be found in your OWL Plugin folder.");
                defaultOntModel = null;
                return null;
            }
        }
        return defaultOntModel;
    }

    public static String getDefaultProfileURI() {
        return OWLProfiles.OWL_DL.getURI();
    }

    public static Set getFeaturesSet(String uri) {
        Set set = (Set)featuresCache.get(uri);
        if (set == null) {
            block4: {
                try {
                    OntModel ontModel = ProfilesManager.getProfileOntModel(uri);
                    OntClass ontClass = ontModel.getOntClass(uri);
                    if (ontClass == null) {
                        ontClass = ProfilesManager.getCustomProfileFeaturesClass(ontModel);
                    }
                    set = ProfilesManager.getSelectedClasses(ontModel, ontClass);
                }
                catch (Exception ex) {
                    if (uri.equals(ProfilesManager.getDefaultProfileURI())) break block4;
                    set = ProfilesManager.getFeaturesSet(ProfilesManager.getDefaultProfileURI());
                }
            }
            featuresCache.put(uri, set);
        }
        return set;
    }

    public static String getPredefinedProfile(OWLModel owlModel) {
        String predefined = owlModel.getOWLProject().getSettingsMap().getString(PREDEFINED_PROFILE_URI_KEY);
        if (predefined == null) {
            return ProfilesManager.getDefaultProfileURI();
        }
        return predefined;
    }

    public static String getProfile(OWLModel owlModel) {
        String custom = ProfilesManager.getCustomProfileURI(owlModel);
        if (custom != null) {
            return custom;
        }
        return ProfilesManager.getPredefinedProfile(owlModel);
    }

    public static OntModel getProfileOntModel(OWLModel owlModel) throws Exception {
        String uri = ProfilesManager.getProfile(owlModel);
        return ProfilesManager.getProfileOntModel(uri);
    }

    public static OntModel getProfileOntModel(String uri) throws Exception {
        if (uri.startsWith("http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#")) {
            return ProfilesManager.getDefaultProfileOntModel();
        }
        return ProfilesManager.getCustomProfileOntModel(uri);
    }

    public static Cls[] getSupportedRestrictionMetaClses(OWLModel owlModel) {
        ArrayList<RDFSNamedClass> result = new ArrayList<RDFSNamedClass>();
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.AllValuesFrom_Restrictions)) {
            result.add(owlModel.getRDFSNamedClass("owl:AllValuesFromRestriction"));
        }
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.SomeValuesFrom_Restrictions)) {
            result.add(owlModel.getRDFSNamedClass("owl:SomeValuesFromRestriction"));
        }
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.HasValue_Restrictions)) {
            result.add(owlModel.getRDFSNamedClass("owl:HasValueRestriction"));
        }
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.MinCardinality_Restrictions)) {
            if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.MaxCardinality_Restrictions)) {
                result.add(owlModel.getRDFSNamedClass("owl:CardinalityRestriction"));
            }
            result.add(owlModel.getRDFSNamedClass("owl:MinCardinalityRestriction"));
        }
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.MaxCardinality_Restrictions)) {
            result.add(owlModel.getRDFSNamedClass("owl:MaxCardinalityRestriction"));
        }
        return result.toArray(new Cls[0]);
    }

    public static Set getSelectedClasses(OntModel ontModel, OntClass featuresClass) {
        HashSet<OntClass> result = new HashSet<OntClass>();
        ProfilesManager.getSubclasses(result, ontModel, featuresClass, true);
        if ("http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#".equals(featuresClass.getNameSpace())) {
            result.add(featuresClass);
        } else {
            result.remove(result);
        }
        return result;
    }

    public static Iterator getSubclasses(OntModel ontModel, OntClass ontClass) {
        HashSet result = new HashSet();
        ProfilesManager.getSubclasses(result, ontModel, ontClass, false);
        result.remove(ontClass);
        return result.iterator();
    }

    private static void getSubclasses(Set result, OntModel ontModel, OntClass ontClass, boolean recursive) {
        ExtendedIterator it = ontClass.listSubClasses(true);
        while (it.hasNext()) {
            OntClass subClass = (OntClass)it.next();
            result.add(subClass);
            if (!recursive) continue;
            ProfilesManager.getSubclasses(result, ontModel, subClass, recursive);
        }
        it = ontModel.listNamedClasses();
        block1: while (it.hasNext()) {
            OntClass c = (OntClass)it.next();
            OntClass equi = c.getEquivalentClass();
            if (equi == null || !equi.canAs(IntersectionClass.class)) continue;
            IntersectionClass in = (IntersectionClass)equi.as(IntersectionClass.class);
            ExtendedIterator oit = in.listOperands();
            while (oit.hasNext()) {
                OntClass operandClass;
                Resource operand = (Resource)oit.next();
                if (!operand.canAs(OntClass.class) || !(operandClass = (OntClass)operand.as(OntClass.class)).equals((Object)ontClass) || result.contains(c)) continue;
                result.add(c);
                if (!recursive) continue block1;
                ProfilesManager.getSubclasses(result, ontModel, c, recursive);
                continue block1;
            }
        }
    }

    public static boolean isFeatureSupported(OWLModel owlModel, OntClass ontClass) {
        String uri = ProfilesManager.getProfile(owlModel);
        Set set = ProfilesManager.getFeaturesSet(uri);
        if (set != null) {
            return set.contains(ontClass);
        }
        return true;
    }

    public static OntModel loadOntModel(String uri) {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ProfilesManager.addAltEntryForOWLProfiles(ontModel);
        ontModel.read(uri, "RDF/XML-ABBREV");
        return ontModel;
    }

    public static void saveOntModel(OntModel newOntModel, String fileName) throws IOException {
        String namespace = newOntModel.getNsPrefixURI("");
        RDFWriter writer = newOntModel.getWriter("RDF/XML-ABBREV");
        Jena.prepareWriter(writer, "RDF/XML-ABBREV", namespace);
        FileOutputStream outputStream = new FileOutputStream(fileName);
        PrintStream ps = new PrintStream(outputStream);
        String encoding = SystemUtilities.getFileEncoding();
        Collection charsets = Charset.availableCharsets().keySet();
        if (!charsets.contains(encoding)) {
            encoding = "UTF-8";
        }
        writer.write(newOntModel.getBaseModel(), (Writer)new OutputStreamWriter((OutputStream)ps, encoding), namespace);
        ((OutputStream)outputStream).close();
    }

    public static void setProfile(OWLModel owlModel, String uri) {
        ProfilesManager.setProfile(owlModel.getOWLProject(), uri);
    }

    public static void setProfile(PropertyList sources, String uri) {
        if (uri.startsWith("http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#")) {
            sources.setString(PREDEFINED_PROFILE_URI_KEY, uri);
            sources.remove(CUSTOM_PROFILE_KEY);
        } else {
            sources.setString(CUSTOM_PROFILE_KEY, uri);
        }
    }

    public static void setProfile(OWLProject project, String uri) {
        SettingsMap settingsMap = project.getSettingsMap();
        if (uri.startsWith("http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#")) {
            settingsMap.setString(PREDEFINED_PROFILE_URI_KEY, uri);
            settingsMap.remove(CUSTOM_PROFILE_KEY);
        } else {
            settingsMap.setString(CUSTOM_PROFILE_KEY, uri);
        }
    }
}

