/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions.tests;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.conditions.tests.AbstractConditionsTableTestCase;

public class ChangeConditionsTableModelTestCase
extends AbstractConditionsTableTestCase {
    public void testAddDirectSuperclass() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        ChangeConditionsTableModelTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(0));
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        personCls.addSuperclass(animalCls);
        ChangeConditionsTableModelTestCase.assertEquals((int)4, (int)tableModel.getRowCount());
        int i = 2;
        ChangeConditionsTableModelTestCase.assertEquals((Object)animalCls, (Object)tableModel.getClass(i));
        ChangeConditionsTableModelTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(i));
        ChangeConditionsTableModelTestCase.assertEquals((Object)this.owlModel.getRootCls(), (Object)tableModel.getClass(++i));
        ChangeConditionsTableModelTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(i));
        ChangeConditionsTableModelTestCase.assertTrue((this.events.size() > 0 ? 1 : 0) != 0);
    }

    public void testRemoveDirectSuperclass() {
        OWLNamedClass personClass = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass animalClass = this.owlModel.createOWLNamedClass("Animal");
        personClass.addSuperclass(animalClass);
        ConditionsTableModel tableModel = this.getTableModel(personClass);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, animalClass, this.owlThing});
        ChangeConditionsTableModelTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(2));
        ChangeConditionsTableModelTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(3));
        personClass.removeSuperclass(animalClass);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing});
        ChangeConditionsTableModelTestCase.assertEquals((Object)this.owlThing, (Object)tableModel.getClass(2));
        ChangeConditionsTableModelTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(2));
        ChangeConditionsTableModelTestCase.assertTrue((this.events.size() > 0 ? 1 : 0) != 0);
    }

    public void testAddNamedEquivalentClass() {
        OWLNamedClass menschCls = this.owlModel.createOWLNamedClass("Mensch");
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        personCls.addEquivalentClass(menschCls);
        personCls.removeSuperclass(this.owlThing);
        ChangeConditionsTableModelTestCase.assertEquals((int)3, (int)tableModel.getRowCount());
        ChangeConditionsTableModelTestCase.assertEquals((Object)menschCls, (Object)tableModel.getClass(1));
        ChangeConditionsTableModelTestCase.assertTrue((boolean)tableModel.isDefinition(1));
        ChangeConditionsTableModelTestCase.assertTrue((this.events.size() > 0 ? 1 : 0) != 0);
    }

    public void testMoveNamedEquivalentClass() {
        OWLNamedClass maleCls = this.owlModel.createOWLNamedClass("Male");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(maleCls);
        intersectionCls.addOperand(this.owlModel.createOWLMinCardinality(property, 1));
        cls.addEquivalentClass(intersectionCls);
        cls.addEquivalentClass(this.owlModel.createOWLMaxCardinality(property, 4));
        cls.addSuperclass(maleCls);
        cls.removeSuperclass(this.owlThing);
        ConditionsTableModel tableModel = this.getTableModel(cls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", maleCls, OWLMinCardinality.class, "SUFFICIENT", OWLMaxCardinality.class, NECESSARY});
        tableModel.addRow(maleCls, 4);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", maleCls, OWLMaxCardinality.class, "SUFFICIENT", maleCls, OWLMinCardinality.class, NECESSARY});
        tableModel.deleteRow(1);
        ChangeConditionsTableModelTestCase.assertTrue((boolean)cls.isSubclassOf(maleCls));
    }

    public void testDeleteRestrictionViaPropertyDelete() {
        OWLNamedClass namedClass = this.owlModel.createOWLNamedClass("Class");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        namedClass.addSuperclass(this.owlModel.createOWLMinCardinality(property, 1));
        ConditionsTableModel tableModel = this.getTableModel(namedClass);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing, OWLMinCardinality.class});
        property.delete();
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing});
    }
}

