/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.code;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.emf.EMFGenerator;
import edu.stanford.smi.protegex.owl.emf.ProjectBasedEMFGeneratorOptions;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.AbstractOWLModelAction;
import edu.stanford.smi.protegex.owl.ui.menu.code.EMFPanel;
import java.util.logging.Level;

public class EMFAction
extends AbstractOWLModelAction {
    public String getMenubarPath() {
        return String.valueOf(CODE_MENU) + "/" + "Java";
    }

    public String getName() {
        return "Generate EMF Java Interfaces...";
    }

    public void run(OWLModel owlModel) {
        ProjectBasedEMFGeneratorOptions options = new ProjectBasedEMFGeneratorOptions(owlModel);
        EMFPanel panel = new EMFPanel(options);
        if (ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(owlModel.getProject()), panel, this.getName(), 11) == 1) {
            panel.ok();
            EMFGenerator creator = new EMFGenerator(owlModel, options);
            try {
                creator.createAllInterfaces();
                ProtegeUI.getModalDialogFactory().showMessageDialog(owlModel, "EMF Interfaces generated.");
            }
            catch (Exception ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "Could not create EMF code:\n" + ex);
            }
        }
    }
}

