/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.test;

import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import junit.framework.Assert;

public class TestUtilities {
    public static AbstractButton getButton(Component component, Icon icon) {
        AbstractButton abstractButton = null;
        for (AbstractButton abstractButton2 : ComponentUtilities.getDescendentsOfClass(AbstractButton.class, component)) {
            if (!icon.equals(abstractButton2.getIcon())) continue;
            abstractButton = abstractButton2;
            break;
        }
        return abstractButton;
    }

    public static void pressButton(Component component, Icon icon) {
        AbstractButton abstractButton = TestUtilities.getButton(component, icon);
        if (abstractButton == null) {
            Assert.fail((String)("No such button: " + icon));
        } else {
            abstractButton.doClick();
            SystemUtilities.sleepMsec(500);
        }
    }

    public static Component selectTab(Component component, Icon icon) {
        Component component2 = null;
        JTabbedPane jTabbedPane = (JTabbedPane)ComponentUtilities.getDescendentOfClass(JTabbedPane.class, component);
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            Icon icon2 = jTabbedPane.getIconAt(i);
            if (!icon.equals(icon2)) continue;
            component2 = jTabbedPane.getComponentAt(i);
            jTabbedPane.setSelectedIndex(i);
        }
        return component2;
    }

    public static Component getLeftComponent(Component component) {
        JSplitPane jSplitPane = (JSplitPane)ComponentUtilities.getDescendentOfClass(JSplitPane.class, component);
        return jSplitPane.getLeftComponent();
    }

    public static Component getRightComponent(Component component) {
        JSplitPane jSplitPane = (JSplitPane)ComponentUtilities.getDescendentOfClass(JSplitPane.class, component);
        return jSplitPane.getLeftComponent();
    }

    public static Component getTopComponent(Component component) {
        JSplitPane jSplitPane = (JSplitPane)ComponentUtilities.getDescendentOfClass(JSplitPane.class, component);
        return jSplitPane.getLeftComponent();
    }

    public static Component getBottomComponent(Component component) {
        JSplitPane jSplitPane = (JSplitPane)ComponentUtilities.getDescendentOfClass(JSplitPane.class, component);
        return jSplitPane.getLeftComponent();
    }

    public static JTree getTree(Component component) {
        return (JTree)ComponentUtilities.getDescendentOfClass(JTree.class, component);
    }

    public static InstanceDisplay getInstanceDisplay(Component component) {
        return (InstanceDisplay)ComponentUtilities.getDescendentOfClass(InstanceDisplay.class, component);
    }

    public static JTree getTreeOnTab(Component component, Icon icon) {
        return TestUtilities.getTree(TestUtilities.getLeftComponent(TestUtilities.selectTab(component, icon)));
    }

    public static void setSelectionOnTree(Component component, Icon icon, Object[] objectArray) {
        JTree jTree = TestUtilities.getTreeOnTab(component, icon);
        ComponentUtilities.setSelectedObjectPath(jTree, Arrays.asList(objectArray));
    }

    public static Object[] getSelectionOnTree(Component component, Icon icon) {
        JTree jTree = TestUtilities.getTreeOnTab(component, icon);
        TreePath treePath = jTree.getSelectionPath();
        return ComponentUtilities.getObjectPath(treePath).toArray();
    }

    public static InstanceDisplay getInstanceDisplayOnTab(Component component, Icon icon) {
        return TestUtilities.getInstanceDisplay(TestUtilities.getRightComponent(TestUtilities.selectTab(component, icon)));
    }
}

