/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.enhanced;

import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.GraphPersonality;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.enhanced.PersonalityConfigException;
import com.hp.hpl.jena.enhanced.Polymorphic;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.util.cache.Cache;
import com.hp.hpl.jena.util.cache.CacheControl;
import com.hp.hpl.jena.util.cache.CacheManager;

public class EnhGraph
extends Polymorphic {
    protected Graph graph;
    private static int cnt = 0;
    protected Cache enhNodes = CacheManager.createCache("ENHNODECACHE", "EnhGraph-" + cnt++, 1000);
    private Personality personality;

    public boolean isValid() {
        return true;
    }

    public EnhGraph(Graph graph, Personality personality) {
        this.graph = graph;
        this.personality = personality;
    }

    public Graph asGraph() {
        return this.graph;
    }

    public final int hashCode() {
        return this.graph.hashCode();
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof EnhGraph && this.graph.equals(((EnhGraph)object).asGraph());
    }

    public final boolean isIsomorphicWith(EnhGraph enhGraph) {
        return this.graph.isIsomorphicWith(enhGraph.graph);
    }

    public EnhNode getNodeAs(Node node, Class clazz) {
        EnhNode enhNode = (EnhNode)this.enhNodes.get(node);
        if (enhNode != null) {
            return enhNode.viewAs(clazz);
        }
        enhNode = (EnhNode)((GraphPersonality)this.personality).nodePersonality().newInstance(clazz, node, this);
        this.enhNodes.put(node, enhNode);
        return enhNode;
    }

    public CacheControl getNodeCacheControl() {
        return this.enhNodes;
    }

    public void setNodeCache(Cache cache) {
        this.enhNodes = cache;
    }

    protected Polymorphic convertTo(Class clazz) {
        throw new PersonalityConfigException("Alternative perspectives on graphs has not been implemented yet");
    }

    protected boolean canSupport(Class clazz) {
        return false;
    }

    protected Personality getPersonality() {
        return this.personality;
    }
}

