/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.Locator;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocatorClassLoader
implements Locator {
    static Log log = LogFactory.getLog((Class)LocatorClassLoader.class);
    ClassLoader classLoader = null;

    LocatorClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public InputStream open(String string) {
        if (this.classLoader == null) {
            return null;
        }
        String string2 = FileUtils.toFilename(string);
        if (string2 == null) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("Not found: " + string));
            }
            return null;
        }
        InputStream inputStream = this.classLoader.getResourceAsStream(string2);
        if (inputStream == null) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("Failed to open: " + string));
            }
            return inputStream;
        }
        if (FileManager.logAllLookups && log.isTraceEnabled()) {
            log.trace((Object)("Found: " + string));
        }
        return inputStream;
    }

    public String getName() {
        return "ClassLoaderLocator";
    }
}

