/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class LoadXMLSchemaDatatypesTestCase
extends AbstractJenaTestCase {
    public void testLoadDateTime() throws Exception {
        String t = "2004-12-21T11:12:13";
        this.loadRemoteOntology("xsdDateTime.owl");
        RDFProperty property = this.owlModel.getRDFProperty("dateTime");
        RDFIndividual instance = this.owlModel.getRDFIndividual("Instance");
        RDFSLiteral literal = (RDFSLiteral)instance.getPropertyValue(property);
        LoadXMLSchemaDatatypesTestCase.assertEquals((String)XSDDatatype.XSDdateTime.getURI(), (String)literal.getDatatype().getURI());
        LoadXMLSchemaDatatypesTestCase.assertEquals((String)t, (String)literal.getString());
    }

    public void testLoadTime() throws Exception {
        String t = "01:54:59";
        this.loadRemoteOntology("xsdTime.owl");
        RDFProperty property = this.owlModel.getRDFProperty("time");
        RDFIndividual instance = this.owlModel.getRDFIndividual("Instance");
        RDFSLiteral literal = (RDFSLiteral)instance.getPropertyValue(property);
        LoadXMLSchemaDatatypesTestCase.assertEquals((String)XSDDatatype.XSDtime.getURI(), (String)literal.getDatatype().getURI());
        LoadXMLSchemaDatatypesTestCase.assertEquals((String)t, (String)literal.getString());
    }

    public void testLoadUnsupportedXMLSchemaDatatypes() throws Exception {
        this.loadRemoteOntology("xml-schema-datatypes.owl");
    }
}

