/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyTreeNode;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RestrictionTreeNode;

public class PropertyTreeNodeTestCase
extends AbstractJenaTestCase {
    public void testDuplicateRestriction() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass baseClass = this.owlModel.createOWLNamedClass("Base");
        OWLNamedClass middleClass = (OWLNamedClass)this.owlModel.createSubclass("Middle", baseClass);
        OWLNamedClass leafClass = (OWLNamedClass)this.owlModel.createSubclass("Leaf", middleClass);
        baseClass.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, baseClass));
        middleClass.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, baseClass));
        PropertyTreeNode node = new PropertyTreeNode(null, leafClass, property, false);
        PropertyTreeNodeTestCase.assertEquals((int)1, (int)node.getChildCount());
        RestrictionTreeNode childNode = node.getRestrictionTreeNode(0);
        PropertyTreeNodeTestCase.assertTrue((boolean)childNode.isInherited());
        PropertyTreeNodeTestCase.assertEquals((String)baseClass.getName(), (String)childNode.getFillerText());
        PropertyTreeNodeTestCase.assertEquals((Object)middleClass, (Object)childNode.getInheritedFromClass());
    }

    public void testOWLSomeValuesFromNonRedundant() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass baseClass = this.owlModel.createOWLNamedClass("Base");
        RDFSNamedClass otherFiller = this.owlModel.getRDFSNamedClassClass();
        baseClass.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, otherFiller));
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Class", baseClass);
        cls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, cls));
        PropertyTreeNode node = new PropertyTreeNode(null, cls, property, false);
        PropertyTreeNodeTestCase.assertEquals((int)2, (int)node.getChildCount());
    }

    public void testOWLSomeValuesFromRedundant() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass baseClass = this.owlModel.createOWLNamedClass("Base");
        baseClass.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, baseClass));
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Class", baseClass);
        cls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, cls));
        PropertyTreeNode node = new PropertyTreeNode(null, cls, property, false);
        PropertyTreeNodeTestCase.assertEquals((int)1, (int)node.getChildCount());
        RestrictionTreeNode childNode = node.getRestrictionTreeNode(0);
        PropertyTreeNodeTestCase.assertFalse((boolean)childNode.isInherited());
        PropertyTreeNodeTestCase.assertEquals((String)cls.getName(), (String)childNode.getFillerText());
    }

    public void testDuplicateQCR1() {
        OWLNamedClass qualifier = this.owlModel.createOWLNamedClass("A");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass restrictedClass = this.owlModel.createOWLNamedClass("Class");
        restrictedClass.addSuperclass(this.owlModel.createOWLMinCardinality(property, 1, qualifier));
        restrictedClass.addSuperclass(this.owlModel.createOWLMinCardinality(property, 2));
        PropertyTreeNode node = new PropertyTreeNode(null, restrictedClass, property, false);
        PropertyTreeNodeTestCase.assertEquals((int)2, (int)node.getChildCount());
    }

    public void testDuplicateQCR2() {
        OWLNamedClass qualifier = this.owlModel.createOWLNamedClass("A");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass restrictedClass = this.owlModel.createOWLNamedClass("Class");
        restrictedClass.addSuperclass(this.owlModel.createOWLMinCardinality(property, 2));
        restrictedClass.addSuperclass(this.owlModel.createOWLMinCardinality(property, 1, qualifier));
        PropertyTreeNode node = new PropertyTreeNode(null, restrictedClass, property, false);
        PropertyTreeNodeTestCase.assertEquals((int)2, (int)node.getChildCount());
    }

    public void testDuplicateQCR3() {
        OWLNamedClass qualifier = this.owlModel.createOWLNamedClass("A");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass restrictedClass = this.owlModel.createOWLNamedClass("Class");
        restrictedClass.addSuperclass(this.owlModel.createOWLMinCardinality(property, 1, qualifier));
        restrictedClass.addSuperclass(this.owlModel.createOWLMinCardinality(property, 2, qualifier));
        PropertyTreeNode node = new PropertyTreeNode(null, restrictedClass, property, false);
        PropertyTreeNodeTestCase.assertEquals((int)2, (int)node.getChildCount());
    }
}

