/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard;

import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.impl.OWLNamespaceManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.table.AbstractTableModel;

public class AddedPrefixesTableModel
extends AbstractTableModel {
    private NamespaceManager manager;
    private ArrayList prefixes;
    public static final int PREFIX_COLUMN = 0;
    public static final int NAMESPACE_COLUMN = 1;
    private static final String[] COLUMN_NAMES = new String[]{"Prefix", "Namespace"};

    public AddedPrefixesTableModel(NamespaceManager manager, Collection addedPrefixes) {
        this.manager = manager;
        this.prefixes = new ArrayList(addedPrefixes);
    }

    public int getRowCount() {
        return this.prefixes.size();
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.prefixes.get(rowIndex);
        }
        return this.manager.getNamespaceForPrefix((String)this.prefixes.get(rowIndex));
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && this.manager.getNamespaceForPrefix((String)aValue) == null && OWLNamespaceManager.isValidPrefix((String)aValue)) {
            String namespace = (String)this.getValueAt(rowIndex, 1);
            this.manager.setPrefix(namespace, (String)aValue);
            this.prefixes.set(rowIndex, aValue);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }
}

