/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SynchronizeReasonerTask
extends AbstractReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;

    public SynchronizeReasonerTask(ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        TimeDifference td = new TimeDifference();
        this.setDescription("Synchronizing reasoner");
        this.setMessage("Synchronizing reasoner...");
        ReasonerLogRecordFactory logRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord parentRecord = logRecordFactory.createInformationMessageLogRecord("Synchronize reasoner", null);
        this.postLogRecord(parentRecord);
        td.markStart();
        this.setProgressIndeterminate(true);
        this.doAbortCheck();
        this.setMessage("Updating reasoner...");
        this.clearKnowledgeBase(parentRecord);
        this.doAbortCheck();
        this.transmitToReasoner(parentRecord);
        this.doAbortCheck();
        this.setProgressIndeterminate(false);
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to synchronize = " + td, parentRecord));
        this.setMessage("Reasoner synchronized");
        this.setProgress(1);
        this.setTaskCompleted();
    }

    protected void clearKnowledgeBase(ReasonerLogRecord parentRecord) throws DIGReasonerException {
        TimeDifference td = new TimeDifference();
        td.markStart();
        this.setMessage("Clearing knowledge base...");
        this.protegeOWLReasoner.getDIGReasoner().clearKnowledgeBase(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to clear knowledgebase = " + td, parentRecord));
    }

    protected void transmitToReasoner(ReasonerLogRecord parentRecord) throws DIGReasonerException {
        TimeDifference td = new TimeDifference();
        this.setMessage("Generating DIG representation...");
        td.markStart();
        Document doc = this.getTranslator().createTellsDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        this.getTranslator().translateToDIG(this.protegeOWLReasoner.getKnowledgeBase(), doc, (Node)doc.getDocumentElement());
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time for DIG conversion = " + td, parentRecord));
        this.doAbortCheck();
        this.setMessage("Updating reasoner");
        td.markStart();
        this.protegeOWLReasoner.getDIGReasoner().performRequest(doc);
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update reasoner = " + td, parentRecord));
    }
}

