/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.storage.clips.ClipsFilesCreateProjectPlugin;
import edu.stanford.smi.protege.storage.clips.ClipsFilesPlugin;
import edu.stanford.smi.protege.storage.clips.IncludedProjectsWizardPage;
import edu.stanford.smi.protege.util.FileField;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ClipsFilesWizardPage
extends WizardPage {
    private FileField clsesFileField;
    private FileField instancesFileField;
    private ClipsFilesPlugin plugin;

    public ClipsFilesWizardPage(Wizard wizard, ClipsFilesPlugin clipsFilesPlugin) {
        super("clips files", wizard);
        this.plugin = clipsFilesPlugin;
        this.createComponents();
        this.layoutComponents();
        this.updateSetPageComplete();
    }

    private void createComponents() {
        this.clsesFileField = new FileField("Classes (.pont) File", null, ".pont", "Classes File");
        this.instancesFileField = new FileField("Instances (.pins) File", null, ".pins", "Instances File");
        this.clsesFileField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ClipsFilesWizardPage.this.onClsFieldChanged();
                ClipsFilesWizardPage.this.updateSetPageComplete();
            }
        });
    }

    private void onClsFieldChanged() {
        String string = this.getClsesFileName();
        String string2 = FileUtilities.replaceExtension(string, ".pins");
        this.instancesFileField.setPath(string2);
    }

    private void updateSetPageComplete() {
        this.setPageComplete(this.getClsesFileName() != null);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        box.add(this.clsesFileField);
        box.add(this.instancesFileField);
        this.add((Component)box, "North");
    }

    public void onFinish() {
        String string = this.getClsesFileName();
        String string2 = this.getInstancesFileName();
        this.plugin.setFiles(string, string2);
    }

    private String getClsesFileName() {
        return ClipsFilesWizardPage.getPath(this.clsesFileField, ".pont");
    }

    private String getInstancesFileName() {
        return ClipsFilesWizardPage.getPath(this.instancesFileField, ".pins");
    }

    private static String getPath(FileField fileField, String string) {
        String string2 = fileField.getPath();
        return FileUtilities.ensureExtension(string2, string);
    }

    public WizardPage getNextPage() {
        WizardPage wizardPage;
        if (this.plugin instanceof ClipsFilesCreateProjectPlugin) {
            ClipsFilesCreateProjectPlugin clipsFilesCreateProjectPlugin = (ClipsFilesCreateProjectPlugin)this.plugin;
            wizardPage = new IncludedProjectsWizardPage(this.getWizard(), clipsFilesCreateProjectPlugin);
        } else {
            wizardPage = super.getNextPage();
        }
        return wizardPage;
    }
}

