/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;

public class SystemMetamodelTestCase
extends AbstractJenaTestCase {
    public void testSystemFrames() {
        Collection ss = this.owlModel.getOWLSystemResources();
        for (Frame frame : ss) {
            SystemMetamodelTestCase.assertTrue((boolean)frame.isSystem());
            SystemMetamodelTestCase.assertFalse((boolean)frame.isEditable());
        }
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Test");
        SystemMetamodelTestCase.assertFalse((boolean)cls.isSystem());
    }

    public void testJavatypeOfSystemClasses() {
        SystemMetamodelTestCase.assertTrue((boolean)(this.owlModel.getCls("rdfs:Class") instanceof RDFSNamedClass));
        SystemMetamodelTestCase.assertTrue((boolean)(this.owlModel.getCls("owl:Class") instanceof OWLNamedClass));
    }

    public void testOWLDeprecatedClass() {
        RDFSNamedClass c = this.owlModel.getRDFSNamedClass("owl:DeprecatedClass");
        SystemMetamodelTestCase.assertSize(1, c.getSuperclasses(false));
        SystemMetamodelTestCase.assertEquals((Object)this.owlModel.getRDFSNamedClassClass(), (Object)c.getFirstSuperclass());
    }

    public void testOWLThing() {
        RDFProperty rdfTypeProperty = this.rdfTypeProperty();
        SystemMetamodelTestCase.assertSize(1, this.owlThing.getPropertyValues(rdfTypeProperty));
        SystemMetamodelTestCase.assertEquals((Object)this.owlModel.getOWLNamedClassClass(), (Object)this.owlThing.getPropertyValue(rdfTypeProperty));
    }

    private RDFProperty rdfTypeProperty() {
        return this.owlModel.getRDFTypeProperty();
    }

    public void testUserDefinedNamedClasses() {
        SystemMetamodelTestCase.assertSize(0, this.owlModel.getUserDefinedOWLNamedClasses());
        SystemMetamodelTestCase.assertSize(0, this.owlModel.getUserDefinedRDFSNamedClasses());
        RDFSNamedClass c = this.owlModel.createRDFSNamedClass("Class");
        SystemMetamodelTestCase.assertSize(0, this.owlModel.getUserDefinedOWLNamedClasses());
        SystemMetamodelTestCase.assertSize(1, this.owlModel.getUserDefinedRDFSNamedClasses());
        SystemMetamodelTestCase.assertContains((Object)c, this.owlModel.getUserDefinedRDFSNamedClasses());
    }

    public void testUserDefinedProperties() {
        SystemMetamodelTestCase.assertSize(0, this.owlModel.getUserDefinedOWLProperties());
        SystemMetamodelTestCase.assertSize(0, this.owlModel.getUserDefinedRDFProperties());
        SystemMetamodelTestCase.assertSize(0, this.owlModel.getVisibleUserDefinedOWLProperties());
        SystemMetamodelTestCase.assertSize(0, this.owlModel.getVisibleUserDefinedRDFProperties());
        RDFProperty property = this.owlModel.createRDFProperty("property");
        SystemMetamodelTestCase.assertSize(0, this.owlModel.getUserDefinedOWLProperties());
        SystemMetamodelTestCase.assertSize(1, this.owlModel.getUserDefinedRDFProperties());
        SystemMetamodelTestCase.assertSize(0, this.owlModel.getVisibleUserDefinedOWLProperties());
        SystemMetamodelTestCase.assertSize(1, this.owlModel.getVisibleUserDefinedRDFProperties());
        property.setVisible(false);
        SystemMetamodelTestCase.assertSize(1, this.owlModel.getUserDefinedRDFProperties());
        SystemMetamodelTestCase.assertSize(0, this.owlModel.getVisibleUserDefinedRDFProperties());
    }

    public void testRanges() {
        SystemMetamodelTestCase.assertEquals((Object)this.owlModel.getXSDstring(), (Object)this.owlModel.getOWLVersionInfoProperty().getRange());
        SystemMetamodelTestCase.assertEquals((Object)ValueType.STRING, (Object)this.owlModel.getRDFSLabelProperty().getValueType());
        SystemMetamodelTestCase.assertEquals((Object)this.owlModel.getXSDint(), (Object)this.owlModel.getRDFProperty("owl:maxCardinality").getRange());
        SystemMetamodelTestCase.assertEquals((Object)this.owlModel.getXSDint(), (Object)this.owlModel.getRDFProperty("owl:minCardinality").getRange());
        SystemMetamodelTestCase.assertEquals((Object)this.owlModel.getXSDint(), (Object)this.owlModel.getRDFProperty("owl:cardinality").getRange());
        SystemMetamodelTestCase.assertEquals((Object)this.owlModel.getRDFSNamedClassClass(), (Object)this.owlModel.getRDFSSubClassOfProperty().getRange());
    }

    public void testRDFSSubPropertyOf() {
        Frame frame = this.owlModel.getFrame("rdfs:subPropertyOf");
        SystemMetamodelTestCase.assertTrue((boolean)(frame instanceof RDFProperty));
    }

    public void testRDFTypeProperty() {
        RDFProperty property = this.owlModel.getRDFTypeProperty();
        SystemMetamodelTestCase.assertFalse((boolean)property.isDomainDefined());
        SystemMetamodelTestCase.assertSize(1, property.getDirectDomain());
        SystemMetamodelTestCase.assertContains((Object)this.owlThing, property.getDirectDomain());
    }

    public void testOWLSameAs() {
        RDFProperty property = this.owlModel.getOWLSameAsProperty();
        SystemMetamodelTestCase.assertEquals((String)"owl:sameAs", (String)property.getName());
        SystemMetamodelTestCase.assertTrue((boolean)property.hasObjectRange());
    }
}

