/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlb;

import edu.stanford.smi.protegex.owl.swrl.bridge.LiteralInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInMethods;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInUtil;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInNotImplementedException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInNameException;
import java.util.List;

public class SWRLBuiltInMethodsImpl
implements SWRLBuiltInMethods {
    private static String SWRLB_NAMESPACE = "swrlb";
    private static String SWRLB_GREATER_THAN = String.valueOf(SWRLB_NAMESPACE) + ":" + "greaterThan";
    private static String SWRLB_LESS_THAN = String.valueOf(SWRLB_NAMESPACE) + ":" + "lessThan";
    private static String SWRLB_EQUAL = String.valueOf(SWRLB_NAMESPACE) + ":" + "equal";
    private static String SWRLB_NOT_EQUAL = String.valueOf(SWRLB_NAMESPACE) + ":" + "notEqual";
    private static String SWRLB_LESS_THAN_OR_EQUAL = String.valueOf(SWRLB_NAMESPACE) + ":" + "lessThanOrEqual";
    private static String SWRLB_ADD = String.valueOf(SWRLB_NAMESPACE) + ":" + "add";
    private static String SWRLB_SUBTRACT = String.valueOf(SWRLB_NAMESPACE) + ":" + "subtract";
    private static String SWRLB_MULTIPLY = String.valueOf(SWRLB_NAMESPACE) + ":" + "multiply";
    private static String SWRLB_DIVIDE = String.valueOf(SWRLB_NAMESPACE) + ":" + "divide";
    private static String SWRLB_INTEGER_DIVIDE = String.valueOf(SWRLB_NAMESPACE) + ":" + "integerDivide";
    private static String SWRLB_MOD = String.valueOf(SWRLB_NAMESPACE) + ":" + "mod";
    private static String SWRLB_POW = String.valueOf(SWRLB_NAMESPACE) + ":" + "pow";
    private static String SWRLB_UNARY_PLUS = String.valueOf(SWRLB_NAMESPACE) + ":" + "unaryPlus";
    private static String SWRLB_UNARY_MINUS = String.valueOf(SWRLB_NAMESPACE) + ":" + "unaryMinus";
    private static String SWRLB_ABS = String.valueOf(SWRLB_NAMESPACE) + ":" + "abs";
    private static String SWRLB_CEILING = String.valueOf(SWRLB_NAMESPACE) + ":" + "ceiling";
    private static String SWRLB_FLOOR = String.valueOf(SWRLB_NAMESPACE) + ":" + "floor";
    private static String SWRLB_ROUND = String.valueOf(SWRLB_NAMESPACE) + ":" + "round";
    private static String SWRLB_ROUND_HALF_TO_EVEN = String.valueOf(SWRLB_NAMESPACE) + ":" + "roundHalfToEven";
    private static String SWRLB_SIN = String.valueOf(SWRLB_NAMESPACE) + ":" + "sin";
    private static String SWRLB_COS = String.valueOf(SWRLB_NAMESPACE) + ":" + "cos";
    private static String SWRLB_TAN = String.valueOf(SWRLB_NAMESPACE) + ":" + "tan";
    private static String SWRLB_BOOLEAN_NOT = String.valueOf(SWRLB_NAMESPACE) + ":" + "booleanNot";
    private static String SWRLB_STRING_EQUAL_IGNORECASE = String.valueOf(SWRLB_NAMESPACE) + ":" + "stringEqualIgnoreCase";
    private static String SWRLB_STRING_CONCAT = String.valueOf(SWRLB_NAMESPACE) + ":" + "stringConcat";
    private static String SWRLB_SUBSTRING = String.valueOf(SWRLB_NAMESPACE) + ":" + "substring";
    private static String SWRLB_STRING_LENGTH = String.valueOf(SWRLB_NAMESPACE) + ":" + "stringLength";
    private static String SWRLB_NORMALIZE_SPACE = String.valueOf(SWRLB_NAMESPACE) + ":" + "normalizeSpace";
    private static String SWRLB_UPPER_CASE = String.valueOf(SWRLB_NAMESPACE) + ":" + "upperCase";
    private static String SWRLB_LOWER_CASE = String.valueOf(SWRLB_NAMESPACE) + ":" + "lowerCase";
    private static String SWRLB_TRANSLATE = String.valueOf(SWRLB_NAMESPACE) + ":" + "translate";
    private static String SWRLB_CONTAINS = String.valueOf(SWRLB_NAMESPACE) + ":" + "contains";
    private static String SWRLB_CONTAINS_IGNORE_CASE = String.valueOf(SWRLB_NAMESPACE) + ":" + "containsIgnoreCase";
    private static String SWRLB_STARTS_WITH = String.valueOf(SWRLB_NAMESPACE) + ":" + "startsWith";
    private static String SWRLB_ENDS_WITH = String.valueOf(SWRLB_NAMESPACE) + ":" + "endsWith";
    private static String SWRLB_SUBSTRING_BEFORE = String.valueOf(SWRLB_NAMESPACE) + ":" + "substringBefore";
    private static String SWRLB_SUBSTRING_AFTER = String.valueOf(SWRLB_NAMESPACE) + ":" + "substringAfter";
    private static String SWRLB_MATCHES = String.valueOf(SWRLB_NAMESPACE) + ":" + "matches";
    private static String SWRLB_REPLACE = String.valueOf(SWRLB_NAMESPACE) + ":" + "replace";
    private static String SWRLB_TOKENIZE = String.valueOf(SWRLB_NAMESPACE) + ":" + "tokenize";

    public boolean greaterThan(List arguments) throws BuiltInException {
        return SWRLBuiltInMethodsImpl.compareTwoArgumentsOfOrderedType(SWRLB_GREATER_THAN, arguments) > 0;
    }

    public boolean lessThan(List arguments) throws BuiltInException {
        return SWRLBuiltInMethodsImpl.compareTwoArgumentsOfOrderedType(SWRLB_LESS_THAN, arguments) < 0;
    }

    public boolean equal(List arguments) throws BuiltInException {
        return this.equal(SWRLB_EQUAL, arguments);
    }

    public boolean notEqual(List arguments) throws BuiltInException {
        return !this.equal(SWRLB_NOT_EQUAL, arguments);
    }

    public boolean lessThanOrEqual(List arguments) throws BuiltInException {
        return this.equal(SWRLB_LESS_THAN_OR_EQUAL, arguments) || this.lessThan(SWRLB_LESS_THAN_OR_EQUAL, arguments);
    }

    public boolean add(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(SWRLB_ADD, 2, arguments.size());
        return this.mathOperation(SWRLB_ADD, arguments);
    }

    public boolean subtract(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_SUBTRACT, 3, arguments.size());
        return this.mathOperation(SWRLB_SUBTRACT, arguments);
    }

    public boolean multiply(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(SWRLB_MULTIPLY, 2, arguments.size());
        return this.mathOperation(SWRLB_MULTIPLY, arguments);
    }

    public boolean divide(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_DIVIDE, 3, arguments.size());
        return this.mathOperation(SWRLB_DIVIDE, arguments);
    }

    public boolean integerDivide(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_INTEGER_DIVIDE, 3, arguments.size());
        return this.mathOperation(SWRLB_INTEGER_DIVIDE, arguments);
    }

    public boolean mod(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_MOD, 3, arguments.size());
        return this.mathOperation(SWRLB_MOD, arguments);
    }

    public boolean pow(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_POW, 3, arguments.size());
        return this.mathOperation(SWRLB_POW, arguments);
    }

    public boolean unaryPlus(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_UNARY_PLUS, 2, arguments.size());
        return this.mathOperation(SWRLB_UNARY_PLUS, arguments);
    }

    public boolean unaryMinus(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_UNARY_MINUS, 2, arguments.size());
        return this.mathOperation(SWRLB_UNARY_MINUS, arguments);
    }

    public boolean abs(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_ABS, 2, arguments.size());
        return this.mathOperation(SWRLB_ABS, arguments);
    }

    public boolean ceiling(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_CEILING, 2, arguments.size());
        return this.mathOperation(SWRLB_CEILING, arguments);
    }

    public boolean floor(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_FLOOR, 2, arguments.size());
        return this.mathOperation(SWRLB_FLOOR, arguments);
    }

    public boolean round(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_ROUND, 2, arguments.size());
        return this.mathOperation(SWRLB_ROUND, arguments);
    }

    public boolean sin(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_SIN, 2, arguments.size());
        return this.mathOperation(SWRLB_SIN, arguments);
    }

    public boolean cos(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_COS, 2, arguments.size());
        return this.mathOperation(SWRLB_COS, arguments);
    }

    public boolean tan(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_TAN, 2, arguments.size());
        return this.mathOperation(SWRLB_TAN, arguments);
    }

    public boolean booleanNot(List arguments) throws BuiltInException {
        boolean result;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_BOOLEAN_NOT, 2, arguments.size());
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_BOOLEAN_NOT, arguments)) {
            if (!SWRLBuiltInUtil.areAllArgumentsBooleans(SWRLB_BOOLEAN_NOT, arguments.subList(1, arguments.size()))) {
                throw new InvalidBuiltInArgumentException(SWRLB_BOOLEAN_NOT, 1, "Expecting a Boolean");
            }
            boolean operationResult = !SWRLBuiltInUtil.getArgumentAsABoolean(SWRLB_BOOLEAN_NOT, 1, arguments);
            arguments.set(0, new LiteralInfo(operationResult));
            result = true;
        } else {
            if (!SWRLBuiltInUtil.areAllArgumentsBooleans(SWRLB_BOOLEAN_NOT, arguments)) {
                throw new InvalidBuiltInArgumentException(SWRLB_BOOLEAN_NOT, "Expecting all Boolean arguments");
            }
            result = !this.equal(SWRLB_BOOLEAN_NOT, arguments);
        }
        return result;
    }

    public boolean stringEqualIgnoreCase(List arguments) throws BuiltInException {
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_STRING_EQUAL_IGNORECASE, arguments)) {
            throw new InvalidBuiltInArgumentException(SWRLB_STRING_EQUAL_IGNORECASE, 0, "Comparison built-ins do not support assignment. Unbound variable used");
        }
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_STRING_EQUAL_IGNORECASE, 2, arguments.size());
        String argument1 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_STRING_EQUAL_IGNORECASE, 0, arguments);
        String argument2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_STRING_EQUAL_IGNORECASE, 1, arguments);
        return argument1.equalsIgnoreCase(argument2);
    }

    public boolean stringConcat(List arguments) throws BuiltInException {
        boolean result;
        String operationResult = "";
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(SWRLB_STRING_CONCAT, 2, arguments.size());
        int argumentNumber = 1;
        while (argumentNumber < arguments.size()) {
            operationResult = operationResult.concat(SWRLBuiltInUtil.getArgumentAsAString(SWRLB_STRING_CONCAT, argumentNumber, arguments));
            ++argumentNumber;
        }
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_STRING_CONCAT, arguments)) {
            arguments.set(0, new LiteralInfo(operationResult));
            result = true;
        } else {
            String argument1 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_STRING_CONCAT, 0, arguments);
            result = argument1.equals(operationResult);
        }
        return result;
    }

    public boolean substring(List arguments) throws BuiltInException {
        boolean result;
        String operationResult;
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(SWRLB_SUBSTRING, 3, arguments.size());
        SWRLBuiltInUtil.checkNumberOfArgumentsAtMost(SWRLB_SUBSTRING, 4, arguments.size());
        String argument2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_SUBSTRING, 1, arguments);
        int startIndex = SWRLBuiltInUtil.getArgumentAsAnInteger(SWRLB_SUBSTRING, 2, arguments);
        if (arguments.size() == 4) {
            int length = SWRLBuiltInUtil.getArgumentAsAnInteger(SWRLB_SUBSTRING, 3, arguments);
            operationResult = argument2.substring(startIndex, length);
        } else {
            operationResult = argument2.substring(startIndex);
        }
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_SUBSTRING, arguments)) {
            arguments.set(0, new LiteralInfo(operationResult));
            result = true;
        } else {
            String argument1 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_SUBSTRING, 0, arguments);
            result = argument1.equals(operationResult);
        }
        return result;
    }

    public boolean stringLength(List arguments) throws BuiltInException {
        boolean result;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_STRING_LENGTH, 2, arguments.size());
        String argument2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_SUBSTRING, 1, arguments);
        int operationResult = argument2.length();
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_STRING_LENGTH, arguments)) {
            arguments.set(0, new LiteralInfo(operationResult));
            result = true;
        } else {
            String argument1 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_SUBSTRING, 0, arguments);
            result = argument1.length() == operationResult;
        }
        return result;
    }

    public boolean upperCase(List arguments) throws BuiltInException {
        boolean result;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_UPPER_CASE, 2, arguments.size());
        String argument2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_UPPER_CASE, 1, arguments);
        String operationResult = argument2.toUpperCase();
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_UPPER_CASE, arguments)) {
            arguments.set(0, new LiteralInfo(operationResult));
            result = true;
        } else {
            String argument1 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_UPPER_CASE, 0, arguments);
            result = argument1.equals(operationResult);
        }
        return result;
    }

    public boolean lowerCase(List arguments) throws BuiltInException {
        boolean result;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_LOWER_CASE, 2, arguments.size());
        String argument2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_LOWER_CASE, 1, arguments);
        String operationResult = argument2.toLowerCase();
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_LOWER_CASE, arguments)) {
            arguments.set(0, new LiteralInfo(operationResult));
            result = true;
        } else {
            String argument1 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_LOWER_CASE, 0, arguments);
            result = argument1.equals(operationResult);
        }
        return result;
    }

    public boolean contains(List arguments) throws BuiltInException {
        String argument2;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_CONTAINS, 2, arguments.size());
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_CONTAINS, arguments)) {
            throw new InvalidBuiltInArgumentException(SWRLB_CONTAINS, 0, "Built-in does not support assignment. Unbound variable used");
        }
        String argument1 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_CONTAINS, 0, arguments);
        return argument1.lastIndexOf(argument2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_CONTAINS, 1, arguments)) != -1;
    }

    public boolean containsIgnoreCase(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_CONTAINS_IGNORE_CASE, 2, arguments.size());
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_CONTAINS_IGNORE_CASE, arguments)) {
            throw new InvalidBuiltInArgumentException(SWRLB_CONTAINS_IGNORE_CASE, 0, "Built-in does not support assignment. Unbound variable used");
        }
        String argument1 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_CONTAINS_IGNORE_CASE, 0, arguments);
        String argument2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_CONTAINS_IGNORE_CASE, 1, arguments);
        return argument1.toLowerCase().lastIndexOf(argument2.toLowerCase()) != -1;
    }

    public boolean startsWith(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_STARTS_WITH, 2, arguments.size());
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_CONTAINS_IGNORE_CASE, arguments)) {
            throw new InvalidBuiltInArgumentException(SWRLB_CONTAINS_IGNORE_CASE, 0, "Built-in does not support assignment. Unbound variable used");
        }
        String argument1 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_STARTS_WITH, 0, arguments);
        String argument2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_STARTS_WITH, 1, arguments);
        return argument1.startsWith(argument2);
    }

    public boolean endsWith(List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_ENDS_WITH, 2, arguments.size());
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_ENDS_WITH, arguments)) {
            throw new InvalidBuiltInArgumentException(SWRLB_ENDS_WITH, 0, "Built-in does not support assignment. Unbound variable used");
        }
        String argument1 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_ENDS_WITH, 0, arguments);
        String argument2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_ENDS_WITH, 1, arguments);
        return argument1.endsWith(argument2);
    }

    private boolean equal(String builtInName, List arguments) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(builtInName, 2, arguments.size());
        if (SWRLBuiltInUtil.isExpectingAssignment(builtInName, arguments)) {
            throw new InvalidBuiltInArgumentException(builtInName, 0, "Comparison built-ins do not support assignment. Unbound variable used");
        }
        if (SWRLBuiltInUtil.isArgumentABoolean(0, arguments)) {
            boolean b2;
            boolean b1 = SWRLBuiltInUtil.getArgumentAsABoolean(builtInName, 0, arguments);
            return b1 == (b2 = SWRLBuiltInUtil.getArgumentAsABoolean(builtInName, 1, arguments));
        }
        return SWRLBuiltInMethodsImpl.compareTwoArgumentsOfOrderedType(builtInName, arguments) == 0;
    }

    private static int compareTwoArgumentsOfOrderedType(String builtInName, List arguments) throws BuiltInException {
        int result = 0;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(builtInName, 2, arguments.size());
        SWRLBuiltInUtil.checkThatAllArgumentsAreOfAnOrderedType(builtInName, arguments);
        if (SWRLBuiltInUtil.isArgumentAString(0, arguments)) {
            String s1 = SWRLBuiltInUtil.getArgumentAsAString(builtInName, 0, arguments);
            String s2 = SWRLBuiltInUtil.getArgumentAsAString(builtInName, 1, arguments);
            return s1.compareTo(s2);
        }
        if (SWRLBuiltInUtil.isArgumentAnInteger(0, arguments)) {
            int i2;
            int i1 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 0, arguments);
            result = i1 < (i2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments)) ? -1 : (i1 > i2 ? 1 : 0);
        } else if (SWRLBuiltInUtil.isArgumentALong(0, arguments)) {
            long l2;
            long l1 = SWRLBuiltInUtil.getArgumentAsALong(builtInName, 0, arguments);
            result = l1 < (l2 = SWRLBuiltInUtil.getArgumentAsALong(builtInName, 1, arguments)) ? -1 : (l1 > l2 ? 1 : 0);
        } else if (SWRLBuiltInUtil.isArgumentAFloat(0, arguments)) {
            float f2;
            float f1 = SWRLBuiltInUtil.getArgumentAsAFloat(builtInName, 0, arguments);
            result = f1 < (f2 = SWRLBuiltInUtil.getArgumentAsAFloat(builtInName, 1, arguments)) ? -1 : (f1 > f2 ? 1 : 0);
        } else if (SWRLBuiltInUtil.isArgumentADouble(0, arguments)) {
            double d2;
            double d1 = SWRLBuiltInUtil.getArgumentAsADouble(builtInName, 0, arguments);
            result = d1 < (d2 = SWRLBuiltInUtil.getArgumentAsADouble(builtInName, 1, arguments)) ? -1 : (d1 > d2 ? 1 : 0);
        } else {
            throw new InvalidBuiltInArgumentException(builtInName, 1, "Unknown argument type");
        }
        return result;
    }

    private boolean lessThan(String builtInName, List arguments) throws BuiltInException {
        return SWRLBuiltInMethodsImpl.compareTwoArgumentsOfOrderedType(builtInName, arguments) < 0;
    }

    private boolean mathOperation(String builtInName, List arguments) throws BuiltInException {
        int argument1 = 0;
        int operationResult = -1;
        boolean result = false;
        boolean isExpectingAssignment = false;
        if (SWRLBuiltInUtil.isExpectingAssignment(builtInName, arguments)) {
            isExpectingAssignment = true;
        }
        if (isExpectingAssignment ? !SWRLBuiltInUtil.areAllArgumentsIntegers(builtInName, arguments.subList(1, arguments.size())) : !SWRLBuiltInUtil.areAllArgumentsIntegers(builtInName, arguments)) {
            throw new BuiltInNotImplementedException(builtInName, "Only built-ins with all integer arguments are supported at the moment");
        }
        if (!isExpectingAssignment) {
            argument1 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 0, arguments);
        }
        if (builtInName.equalsIgnoreCase(SWRLB_ADD)) {
            operationResult = 0;
            int argumentNumber = 1;
            while (argumentNumber < arguments.size()) {
                operationResult += SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, argumentNumber, arguments);
                ++argumentNumber;
            }
        } else if (builtInName.equalsIgnoreCase(SWRLB_MULTIPLY)) {
            operationResult = 1;
            int argumentNumber = 1;
            while (argumentNumber < arguments.size()) {
                operationResult *= SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, argumentNumber, arguments);
                ++argumentNumber;
            }
        } else if (builtInName.equalsIgnoreCase(SWRLB_SUBTRACT)) {
            int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
            int argument3 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 2, arguments);
        } else if (builtInName.equalsIgnoreCase(SWRLB_DIVIDE)) {
            int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
            int argument3 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 2, arguments);
            operationResult = argument2 / argument3;
        } else if (builtInName.equalsIgnoreCase(SWRLB_INTEGER_DIVIDE)) {
            int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
            int argument3 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 2, arguments);
            if (argument3 == 0) {
                throw new InvalidBuiltInArgumentException(builtInName, 2, "Zero passed as divisor");
            }
            operationResult = argument3 >= 0 ? argument2 + argument3 + 1 / argument3 : argument2 / argument3;
        } else if (builtInName.equalsIgnoreCase(SWRLB_MOD)) {
            int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
            int argument3 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 2, arguments);
            operationResult = argument2 % argument3;
        } else if (builtInName.equalsIgnoreCase(SWRLB_POW)) {
            int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
            int argument3 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 2, arguments);
            operationResult = (int)Math.pow(argument2, argument3);
        } else if (builtInName.equalsIgnoreCase(SWRLB_UNARY_PLUS)) {
            int argument2;
            operationResult = argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
        } else if (builtInName.equalsIgnoreCase(SWRLB_UNARY_MINUS)) {
            int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
            operationResult = -argument2;
        } else if (builtInName.equalsIgnoreCase(SWRLB_ABS)) {
            int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
            operationResult = Math.abs(argument2);
        } else if (builtInName.equalsIgnoreCase(SWRLB_CEILING)) {
            int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
            operationResult = (int)Math.ceil(argument2);
        } else if (builtInName.equalsIgnoreCase(SWRLB_FLOOR)) {
            int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
            operationResult = (int)Math.floor(argument2);
        } else if (builtInName.equalsIgnoreCase(SWRLB_ROUND)) {
            int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
            operationResult = (int)Math.rint(argument2);
        } else {
            if (builtInName.equalsIgnoreCase(SWRLB_ROUND_HALF_TO_EVEN)) {
                int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
                throw new BuiltInNotImplementedException(SWRLB_ROUND_HALF_TO_EVEN);
            }
            if (builtInName.equalsIgnoreCase(SWRLB_SIN)) {
                int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
                operationResult = (int)Math.sin(argument2);
            } else if (builtInName.equalsIgnoreCase(SWRLB_COS)) {
                int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
                operationResult = (int)Math.cos(argument2);
            } else if (builtInName.equalsIgnoreCase(SWRLB_TAN)) {
                int argument2 = SWRLBuiltInUtil.getArgumentAsAnInteger(builtInName, 1, arguments);
                operationResult = (int)Math.tan(argument2);
            } else {
                throw new InvalidBuiltInNameException(builtInName);
            }
        }
        if (isExpectingAssignment) {
            arguments.set(0, new LiteralInfo(operationResult));
            result = true;
        } else {
            result = argument1 == operationResult;
        }
        return result;
    }
}

