/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.TransferableCollection;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ResourceAdapter;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;

public class AssertedTypesListPanel
extends SelectableContainer {
    private Action addAction;
    private SelectableList list;
    private OWLModel owlModel;
    private RDFResource resource;
    private ResourceListener resourceListener = new ResourceAdapter(){

        public void typeAdded(RDFResource resource, RDFSClass type) {
            ComponentUtilities.addListValue((JList)AssertedTypesListPanel.this.list, (Object)type);
        }

        public void typeRemoved(RDFResource resource, RDFSClass type) {
            ComponentUtilities.removeListValue((JList)AssertedTypesListPanel.this.list, (Object)type);
        }
    };

    public AssertedTypesListPanel(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.list = ComponentFactory.createSelectableList(null);
        this.list.setCellRenderer((ListCellRenderer)((Object)new ResourceRenderer()));
        this.setSelectable((Selectable)this.list);
        OWLLabeledComponent lc = new OWLLabeledComponent("Asserted Types", new JScrollPane((Component)this.list));
        lc.addHeaderButton(this.createAddTypeAction());
        lc.addHeaderButton(this.createRemoveTypeAction());
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)lc));
        this.setPreferredSize(new Dimension(0, 100));
        this.list.setDragEnabled(true);
        this.list.setTransferHandler((TransferHandler)new FrameTransferHandler());
    }

    public void setResource(RDFResource newResource) {
        if (this.resource != null) {
            this.resource.removeResourceListener(this.resourceListener);
        }
        this.resource = newResource;
        if (this.resource != null) {
            this.resource.addResourceListener(this.resourceListener);
        }
        this.updateModel();
        this.updateAddButton();
    }

    public void updateModel() {
        SimpleListModel model;
        if (this.resource == null) {
            model = new DefaultListModel();
        } else {
            Collection types = this.resource.getRDFTypes();
            model = new SimpleListModel(types);
        }
        this.list.setModel(model);
    }

    public void updateAddButton() {
        this.addAction.setEnabled(this.resource != null);
    }

    private Action createAddTypeAction() {
        this.addAction = new AddAction("Add type...", OWLIcons.getAddIcon("PrimitiveClass")){

            public void onAdd() {
                Set clses = ProtegeUI.getSelectionDialogFactory().selectClasses((Component)((Object)AssertedTypesListPanel.this), AssertedTypesListPanel.this.owlModel, "Select type to add");
                for (RDFSClass cls : clses) {
                    AssertedTypesListPanel.this.resource.addProtegeType(cls);
                }
            }
        };
        return this.addAction;
    }

    private Action createRemoveTypeAction() {
        return new RemoveAction("Remove selected type", (Selectable)this.list, OWLIcons.getRemoveIcon("PrimitiveClass")){

            public void onRemove(Object o) {
                if (o instanceof RDFSClass) {
                    if (AssertedTypesListPanel.this.resource.getRDFTypes().size() > 1) {
                        AssertedTypesListPanel.this.resource.removeProtegeType((RDFSClass)o);
                    } else {
                        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(AssertedTypesListPanel.this.owlModel, "Resources must have at least one remaining type.");
                    }
                }
            }
        };
    }

    private class FrameTransferHandler
    extends TransferHandler {
        private FrameTransferHandler() {
        }

        protected Transferable createTransferable(JComponent c) {
            Collection collection = AssertedTypesListPanel.this.getSelection();
            return collection.isEmpty() ? null : new TransferableCollection(collection);
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            return true;
        }

        public boolean importData(JComponent component, Transferable data) {
            return true;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            if (action == 2) {
                for (RDFSClass type : AssertedTypesListPanel.this.getSelection()) {
                    int index = 0;
                    Log.getLogger().info("Move " + type + " to: " + index);
                    AssertedTypesListPanel.this.resource.moveDirectType(type, index);
                    AssertedTypesListPanel.this.updateModel();
                }
            }
        }

        public int getSourceActions(JComponent c) {
            return 2;
        }
    }
}

