/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.testing.sanity.SubpropertyRangeMustNarrowTest;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collections;

public class SubPropertyRangeMustNarrowTestTestCase
extends AbstractJenaTestCase {
    public void testSimpleNarrowing() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty superSlot = this.owlModel.createOWLObjectProperty("superSlot");
        OWLObjectProperty subSlot = this.owlModel.createOWLObjectProperty("subSlot");
        subSlot.addSuperproperty(superSlot);
        subSlot.addUnionRangeClass(cls);
        SubPropertyRangeMustNarrowTestTestCase.assertNull((Object)SubpropertyRangeMustNarrowTest.fails(superSlot));
        SubPropertyRangeMustNarrowTestTestCase.assertNull((Object)SubpropertyRangeMustNarrowTest.fails(subSlot));
    }

    public void testSimpleWidening() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("SuperCls");
        OWLNamedClass subCls = this.owlModel.createOWLNamedSubclass("SubCls", superCls);
        OWLObjectProperty superSlot = this.owlModel.createOWLObjectProperty("superSlot");
        superSlot.addUnionRangeClass(subCls);
        OWLObjectProperty subSlot = this.owlModel.createOWLObjectProperty("subSlot");
        subSlot.addSuperproperty(superSlot);
        subSlot.setUnionRangeClasses(Collections.singleton(superCls));
        SubPropertyRangeMustNarrowTestTestCase.assertSize(1, subSlot.getUnionRangeClasses());
        SubPropertyRangeMustNarrowTestTestCase.assertNull((Object)SubpropertyRangeMustNarrowTest.fails(superSlot));
        SubPropertyRangeMustNarrowTestTestCase.assertEquals((Object)superSlot, (Object)SubpropertyRangeMustNarrowTest.fails(subSlot));
    }

    public void testUnionWidening() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("SuperCls");
        OWLNamedClass subCls = this.owlModel.createOWLNamedSubclass("SubCls", superCls);
        OWLObjectProperty superSlot = this.owlModel.createOWLObjectProperty("superSlot");
        superSlot.addUnionRangeClass(subCls);
        OWLObjectProperty subSlot = this.owlModel.createOWLObjectProperty("subSlot");
        subSlot.addSuperproperty(superSlot);
        subSlot.setUnionRangeClasses(Collections.singleton(superCls));
        subSlot.addUnionRangeClass(subCls);
        SubPropertyRangeMustNarrowTestTestCase.assertNull((Object)SubpropertyRangeMustNarrowTest.fails(superSlot));
        SubPropertyRangeMustNarrowTestTestCase.assertEquals((Object)superSlot, (Object)SubpropertyRangeMustNarrowTest.fails(subSlot));
    }

    public void testOk() {
        OWLNamedClass topCls = this.owlModel.createOWLNamedClass("Top");
        OWLNamedClass middleCls = this.owlModel.createOWLNamedSubclass("Middle", topCls);
        OWLNamedClass leafCls = this.owlModel.createOWLNamedSubclass("Leaf", middleCls);
        OWLObjectProperty topSlot = this.owlModel.createOWLObjectProperty("top");
        topSlot.setUnionRangeClasses(Collections.singleton(topCls));
        OWLObjectProperty middleSlot = this.owlModel.createOWLObjectProperty("middle");
        middleSlot.addSuperproperty(topSlot);
        middleSlot.setUnionRangeClasses(Collections.singleton(middleCls));
        OWLObjectProperty leafSlot = this.owlModel.createOWLObjectProperty("leafSlot");
        leafSlot.addSuperproperty(middleSlot);
        leafSlot.setUnionRangeClasses(Collections.singleton(leafCls));
        SubPropertyRangeMustNarrowTestTestCase.assertNull((Object)SubpropertyRangeMustNarrowTest.fails(topSlot));
        SubPropertyRangeMustNarrowTestTestCase.assertNull((Object)SubpropertyRangeMustNarrowTest.fails(middleSlot));
        SubPropertyRangeMustNarrowTestTestCase.assertNull((Object)SubpropertyRangeMustNarrowTest.fails(leafSlot));
    }
}

