/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.explorer;

import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerFilter;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RDFSNamedClassTreeNode
extends ExplorerTreeNode {
    public RDFSNamedClassTreeNode(LazyTreeNode parent, RDFSNamedClass namedClass, ExplorerFilter filter) {
        super(parent, namedClass, filter);
    }

    protected List createChildObjects() {
        RDFSNamedClass namedClass = (RDFSNamedClass)this.getRDFSClass();
        ArrayList<RDFSClass> results = new ArrayList<RDFSClass>();
        Collection superclasses = namedClass.getSuperclasses(false);
        if (this.filter.getUseInferredSuperclasses() && namedClass instanceof OWLNamedClass) {
            superclasses = ((OWLNamedClass)namedClass).getInferredSuperclasses();
        }
        for (RDFSClass superclass : superclasses) {
            if (superclass instanceof OWLIntersectionClass && superclass.getSuperclasses(false).contains(namedClass)) {
                OWLIntersectionClass intersectionClass = (OWLIntersectionClass)superclass;
                for (RDFSClass operand : intersectionClass.getOperands()) {
                    if (results.contains(operand)) continue;
                    results.add(operand);
                }
                continue;
            }
            if (results.contains(superclass)) continue;
            results.add(superclass);
        }
        return results;
    }
}

