/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.regexptrees.test;

import com.hp.hpl.jena.graph.query.regexptrees.AnyOf;
import com.hp.hpl.jena.graph.query.regexptrees.AnySingle;
import com.hp.hpl.jena.graph.query.regexptrees.BackReference;
import com.hp.hpl.jena.graph.query.regexptrees.EndOfLine;
import com.hp.hpl.jena.graph.query.regexptrees.NoneOf;
import com.hp.hpl.jena.graph.query.regexptrees.OneOrMore;
import com.hp.hpl.jena.graph.query.regexptrees.Optional;
import com.hp.hpl.jena.graph.query.regexptrees.Paren;
import com.hp.hpl.jena.graph.query.regexptrees.RegexpTree;
import com.hp.hpl.jena.graph.query.regexptrees.StartOfLine;
import com.hp.hpl.jena.graph.query.regexptrees.Text;
import com.hp.hpl.jena.graph.query.regexptrees.ZeroOrMore;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestRegexpTrees
extends GraphTestBase {
    protected Object[][] equalities = new Object[][]{{new EndOfLine(), "EOL"}, {new EndOfLine(), "EOL"}, {new StartOfLine(), "SOL"}, {new StartOfLine(), "SOL"}, {new AnySingle(), "ANY"}, {new AnySingle(), "ANY"}, {new Paren(new AnySingle()), "(ANY)"}, {new Paren(new EndOfLine()), "(EOL)"}, {Text.create("hello"), "hello"}, {Text.create("goodbye"), "goodbye"}, {new AnyOf("abcde"), "any[abcde]"}, {new AnyOf("defgh"), "any[defgh]"}, {new NoneOf("pqrst"), "none[pqrst]"}, {new NoneOf("12345"), "none[12345]"}, {new BackReference(1), "back(1)"}, {new BackReference(2), "back(2)"}};

    public TestRegexpTrees(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRegexpTrees.class);
    }

    public void testEqualities() {
        for (int i = 0; i < this.equalities.length; ++i) {
            for (int j = 0; j < this.equalities.length; ++j) {
                Object[] objectArray = this.equalities[i];
                Object[] objectArray2 = this.equalities[j];
                boolean bl = objectArray[1].equals(objectArray2[1]);
                if (objectArray[0].equals(objectArray2[0]) == bl) continue;
                TestRegexpTrees.fail((String)(objectArray[0] + " should be " + (bl ? "equal to " : "different from ") + objectArray2[0]));
            }
        }
    }

    public void testConstantsDefinition() {
        TestRegexpTrees.assertEquals((Object)RegexpTree.EOL, (Object)new EndOfLine());
        TestRegexpTrees.assertEquals((Object)RegexpTree.SOL, (Object)new StartOfLine());
        TestRegexpTrees.assertEquals((Object)RegexpTree.ANY, (Object)new AnySingle());
    }

    public void testExtractOperandFromOneOrMore() {
        this.testExtractFromOneOrMore(RegexpTree.EOL);
        this.testExtractFromOneOrMore(RegexpTree.SOL);
        this.testExtractFromOneOrMore(RegexpTree.ANY);
    }

    public void testExtractOperandFromZeroOrMore() {
        this.testExtractFromZeroOrMore(RegexpTree.EOL);
        this.testExtractFromZeroOrMore(RegexpTree.SOL);
        this.testExtractFromZeroOrMore(RegexpTree.ANY);
    }

    public void testExtractOperandFromOptional() {
        this.testExtractFromOptional(RegexpTree.EOL);
        this.testExtractFromOptional(RegexpTree.SOL);
        this.testExtractFromOptional(RegexpTree.ANY);
    }

    public void testLiteralContents() {
        TestRegexpTrees.assertEquals((String)"hello", (String)Text.create("hello").getString());
    }

    public void testParenOperand() {
        TestRegexpTrees.assertSame((Object)RegexpTree.EOL, (Object)new Paren(RegexpTree.EOL).getOperand());
    }

    public void testParenIndex() {
        TestRegexpTrees.assertEquals((int)0, (int)new Paren(RegexpTree.EOL).getIndex());
        TestRegexpTrees.assertEquals((int)1, (int)new Paren(RegexpTree.EOL, 1).getIndex());
        TestRegexpTrees.assertEquals((int)17, (int)new Paren(RegexpTree.NON, 17).getIndex());
    }

    public void testBackReference() {
        TestRegexpTrees.assertEquals((int)2, (int)new BackReference(2).getIndex());
    }

    protected void testExtractFromOneOrMore(RegexpTree regexpTree) {
        TestRegexpTrees.assertSame((Object)regexpTree, (Object)new OneOrMore(regexpTree).getOperand());
    }

    protected void testExtractFromZeroOrMore(RegexpTree regexpTree) {
        TestRegexpTrees.assertSame((Object)regexpTree, (Object)new ZeroOrMore(regexpTree).getOperand());
    }

    protected void testExtractFromOptional(RegexpTree regexpTree) {
        TestRegexpTrees.assertSame((Object)regexpTree, (Object)new Optional(regexpTree).getOperand());
    }
}

