/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.PrefixMapping;
import junit.framework.TestSuite;

public class TestTriple
extends GraphTestBase {
    private static final String U = "http://some.domain.name/magic/spells.incant";
    private static final String N = "Alice";
    private static final LiteralLabel L = new LiteralLabel("ashes are burning", "en", false);

    public TestTriple(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTriple.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTripleEquals() {
        try {
            int n;
            int n2;
            Node.cache(false);
            AnonId anonId = new AnonId();
            LiteralLabel literalLabel = new LiteralLabel(anonId.toString(), "", false);
            String string = anonId.toString();
            String string2 = anonId.toString();
            Node[] nodeArray = new Node[]{Node.ANY, Node.createAnon(anonId), Node.createAnon(), Node.createLiteral(L), Node.createLiteral(literalLabel), Node.createURI(U), Node.createURI(string), Node.createVariable(N), Node.createVariable(string2)};
            Triple[] tripleArray = new Triple[nodeArray.length * nodeArray.length * nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                for (n2 = 0; n2 < nodeArray.length; ++n2) {
                    for (n = 0; n < nodeArray.length; ++n) {
                        tripleArray[i * nodeArray.length * nodeArray.length + n2 * nodeArray.length + n] = new Triple(nodeArray[i], nodeArray[n2], nodeArray[n]);
                    }
                }
            }
            boolean[][] blArray = new boolean[tripleArray.length][tripleArray.length];
            for (n2 = 0; n2 < nodeArray.length; ++n2) {
                for (n = 0; n < nodeArray.length; ++n) {
                    for (int i = 0; i < nodeArray.length; ++i) {
                        for (int j = 0; j < nodeArray.length; ++j) {
                            for (int k = 0; k < nodeArray.length; ++k) {
                                for (int i2 = 0; i2 < nodeArray.length; ++i2) {
                                    blArray[n2 * nodeArray.length * nodeArray.length + n * nodeArray.length + i][j * nodeArray.length * nodeArray.length + k * nodeArray.length + i2] = nodeArray[n2].equals(nodeArray[j]) && nodeArray[n].equals(nodeArray[k]) && nodeArray[i].equals(nodeArray[i2]);
                                }
                            }
                        }
                    }
                }
            }
            TestTriple.assertEquals((String)"triple, null", (boolean)tripleArray[0].equals(null), (boolean)false);
            TestTriple.assertDiffer("triple, string", tripleArray[0], "string");
            for (n2 = 0; n2 < tripleArray.length; ++n2) {
                for (n = 0; n < tripleArray.length; ++n) {
                    if (blArray[n2][n]) {
                        TestTriple.assertEquals((String)("triples " + n2 + ", " + n), (Object)tripleArray[n2], (Object)tripleArray[n]);
                        continue;
                    }
                    TestTriple.assertDiffer("triples" + n2 + ", " + n, tripleArray[n2], tripleArray[n]);
                }
            }
        }
        finally {
            Node.cache(true);
        }
    }

    public void testTripleCreate() {
        Node node = Node.create("s");
        Node node2 = Node.create("p");
        Node node3 = Node.create("o");
        TestTriple.assertEquals((Object)new Triple(node, node2, node3), (Object)Triple.create(node, node2, node3));
    }

    public void testTripleCreateFromString() {
        Node node = Node.create("a");
        Node node2 = Node.create("_P");
        Node node3 = Node.create("?c");
        TestTriple.assertEquals((Object)new Triple(node, node2, node3), (Object)Triple.create("a _P ?c"));
    }

    public void testTriplePrefixes() {
        Node node = Node.create("rdf:alpha");
        Node node2 = Node.create("dc:creator");
        Node node3 = Node.create("spoo:notmapped");
        Triple triple = Triple.create("rdf:alpha dc:creator spoo:notmapped");
        TestTriple.assertEquals((Object)new Triple(node, node2, node3), (Object)triple);
    }

    public void testTripleCreationMapped() {
        PrefixMapping prefixMapping = PrefixMapping.Factory.create().setNsPrefix("a", "ftp://foo/").setNsPrefix("b", "http://spoo/");
        Triple triple = Triple.create("ftp://foo/x http://spoo/y c:z");
        Triple triple2 = Triple.create(prefixMapping, "a:x b:y c:z");
        TestTriple.assertEquals((Object)triple, (Object)triple2);
    }

    public void testPlainTripleMatches() {
        this.testMatches("S P O");
        this.testMatches("_S _P _O");
        this.testMatches("1 2 3");
    }

    public void testAnyTripleMatches() {
        this.testMatches("?? P O", "Z P O");
        this.testMatches("S ?? O", "S Q O");
        this.testMatches("S P ??", "S P oh");
        this.testMatches("?? ?? ??", "X Y Z");
        this.testMatches("?? ?? ??", "X Y 1");
        this.testMatches("?? ?? ??", "_X Y Z");
        this.testMatches("?? ?? ??", "X _Y Z");
    }

    private void testMatches(String string) {
        this.testMatches(string, string);
    }

    private void testMatches(String string, String string2) {
        TestTriple.assertTrue((boolean)Triple.create(string).matches(Triple.create(string2)));
    }

    public void testPlainTripleDoesntMatch() {
        this.testMatchFails("S P O", "Z P O");
        this.testMatchFails("S P O", "S Q O");
        this.testMatchFails("S P O", "S P oh");
    }

    public void testAnyTripleDoesntMatch() {
        this.testMatchFails("?? P O", "S P oh");
        this.testMatchFails("S ?? O", "Z R O");
        this.testMatchFails("S P ??", "Z P oh");
    }

    public void testMatchFails(String string, String string2) {
        TestTriple.assertFalse((boolean)Triple.create(string).matches(Triple.create(string2)));
    }

    public void testMatchesNodes() {
        TestTriple.assertTrue((boolean)Triple.create("S P O").matches(TestTriple.node("S"), TestTriple.node("P"), TestTriple.node("O")));
        TestTriple.assertTrue((boolean)Triple.create("?? P O").matches(TestTriple.node("Z"), TestTriple.node("P"), TestTriple.node("O")));
        TestTriple.assertTrue((boolean)Triple.create("S ?? O").matches(TestTriple.node("S"), TestTriple.node("Q"), TestTriple.node("O")));
        TestTriple.assertTrue((boolean)Triple.create("S P ??").matches(TestTriple.node("S"), TestTriple.node("P"), TestTriple.node("I")));
        TestTriple.assertFalse((boolean)Triple.create("S P O").matches(TestTriple.node("Z"), TestTriple.node("P"), TestTriple.node("O")));
        TestTriple.assertFalse((boolean)Triple.create("S P O").matches(TestTriple.node("S"), TestTriple.node("Q"), TestTriple.node("O")));
        TestTriple.assertFalse((boolean)Triple.create("S P O").matches(TestTriple.node("Z"), TestTriple.node("P"), TestTriple.node("I")));
    }

    public void testElementMatches() {
        TestTriple.assertTrue((boolean)Triple.create("S P O").subjectMatches(TestTriple.node("S")));
        TestTriple.assertTrue((boolean)Triple.create("S P O").predicateMatches(TestTriple.node("P")));
        TestTriple.assertTrue((boolean)Triple.create("S P O").objectMatches(TestTriple.node("O")));
        TestTriple.assertFalse((boolean)Triple.create("S P O").subjectMatches(TestTriple.node("Z")));
        TestTriple.assertFalse((boolean)Triple.create("S P O").predicateMatches(TestTriple.node("Q")));
        TestTriple.assertFalse((boolean)Triple.create("S P O").objectMatches(TestTriple.node("I")));
        TestTriple.assertTrue((boolean)Triple.create("?? P O").subjectMatches(TestTriple.node("SUB")));
        TestTriple.assertTrue((boolean)Triple.create("S ?? O").predicateMatches(TestTriple.node("PRED")));
        TestTriple.assertTrue((boolean)Triple.create("S P ??").objectMatches(TestTriple.node("OBJ")));
    }

    public void testConcrete() {
        TestTriple.assertTrue((boolean)Triple.create("S P O").isConcrete());
        TestTriple.assertTrue((boolean)Triple.create("S P 11").isConcrete());
        TestTriple.assertTrue((boolean)Triple.create("S P _X").isConcrete());
        TestTriple.assertTrue((boolean)Triple.create("S _P 11").isConcrete());
        TestTriple.assertTrue((boolean)Triple.create("_S _P _O").isConcrete());
        TestTriple.assertTrue((boolean)Triple.create("10 11 12").isConcrete());
        TestTriple.assertTrue((boolean)Triple.create("S P 11").isConcrete());
        TestTriple.assertFalse((boolean)Triple.create("?? P 11").isConcrete());
        TestTriple.assertFalse((boolean)Triple.create("S ?? 11").isConcrete());
        TestTriple.assertFalse((boolean)Triple.create("S P ??").isConcrete());
        TestTriple.assertFalse((boolean)Triple.create("?S P 11").isConcrete());
        TestTriple.assertFalse((boolean)Triple.create("S ?P 11").isConcrete());
        TestTriple.assertFalse((boolean)Triple.create("S P ?O").isConcrete());
    }

    public void testTripleToStringOrdering() {
        Triple triple = Triple.create("subject predicate object");
        TestTriple.assertTrue((String)"subject must be present", (triple.toString().indexOf("subject") >= 0 ? 1 : 0) != 0);
        TestTriple.assertTrue((String)"subject must preceed predicate", (triple.toString().indexOf("subject") < triple.toString().indexOf("predicate") ? 1 : 0) != 0);
        TestTriple.assertTrue((String)"predicate must preceed object", (triple.toString().indexOf("predicate") < triple.toString().indexOf("object") ? 1 : 0) != 0);
    }

    public void testTripleToStringQuoting() {
        Triple triple = Triple.create("subject predicate 'object'");
        TestTriple.assertTrue((triple.toString().indexOf("\"object\"") > 0 ? 1 : 0) != 0);
    }

    public void testTripleToStringWithPrefixing() {
        PrefixMapping prefixMapping = PrefixMapping.Factory.create();
        prefixMapping.setNsPrefix("spoo", "eg://domain.dom/spoo#");
        Triple triple = Triple.create("eg://domain.dom/spoo#a b c");
        TestTriple.assertEquals((String)"spoo:a @eh:/b eh:/c", (String)triple.toString(prefixMapping));
    }
}

