/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.net.URI;

public class LoadRDFFileTestCase
extends AbstractJenaTestCase {
    public void testLoadFOAF() throws Exception {
        this.loadTestOntology(new URI("http://xmlns.com/foaf/0.1/index.rdf"));
        this.owlModel.getOntModel();
    }

    public void testLoadICalOntology() throws Exception {
        this.loadTestOntology(new URI("http://www.w3.org/2002/12/cal/ical"));
        this.owlModel.getOntModel();
    }

    public void testLoadRDF() throws Exception {
        this.loadRemoteOntology("rdf-test.owl");
        RDFSNamedClass animalCls = this.owlModel.getRDFSNamedClass("Animal");
        LoadRDFFileTestCase.assertTrue((boolean)(animalCls instanceof RDFSNamedClass));
        LoadRDFFileTestCase.assertFalse((boolean)(animalCls instanceof OWLNamedClass));
        RDFProperty hasChildrenProperty = this.owlModel.getRDFProperty("hasChildren");
        LoadRDFFileTestCase.assertTrue((boolean)(hasChildrenProperty instanceof RDFProperty));
        LoadRDFFileTestCase.assertFalse((boolean)(hasChildrenProperty instanceof OWLProperty));
        RDFIndividual purzel = this.owlModel.getRDFIndividual("Purzel");
        LoadRDFFileTestCase.assertEquals((Object)animalCls, (Object)purzel.getProtegeType());
        Instance susie = this.owlModel.getInstance("Susie");
        LoadRDFFileTestCase.assertEquals((Object)animalCls, (Object)susie.getDirectType());
        LoadRDFFileTestCase.assertSize(1, purzel.getPropertyValues(hasChildrenProperty));
        LoadRDFFileTestCase.assertEquals((Object)susie, (Object)purzel.getPropertyValue(hasChildrenProperty));
    }
}

