/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.AssertedClassesPanel;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchiesHost;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchiesPanel;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyManager;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyPanel;
import edu.stanford.smi.protegex.owl.ui.clsdesc.DisjointClassesWidget;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsWidget;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryTabWidget;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourcePanel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import edu.stanford.smi.protegex.owl.ui.subsumption.ChangedClassesPanel;
import edu.stanford.smi.protegex.owl.ui.subsumption.InferredSubsumptionTreePanel;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractTabWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTree;

public class OWLClassesTab
extends AbstractTabWidget
implements NavigationHistoryTabWidget,
HierarchiesHost {
    protected AssertedClassesPanel clsesPanel;
    protected HierarchiesPanel hierarchiesPanel;
    protected JSplitPane mainSplitPane;
    protected ResourcePanel resourcePanel;

    protected JComponent createAssertedClsesPane() {
        this.clsesPanel = this.createClsesPanel();
        return this.clsesPanel;
    }

    protected ResourcePanel createResourcePanel() {
        return ProtegeUI.getResourcePanelFactory().createResourcePanel(this.getOWLModel(), 0);
    }

    private AssertedClassesPanel createClsesPanel() {
        AssertedClassesPanel assertedClsesPanel = new AssertedClassesPanel(this.getOWLModel(), (HierarchyManager)this.hierarchiesPanel);
        assertedClsesPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                OWLClassesTab.this.transmitSelection();
            }
        });
        return assertedClsesPanel;
    }

    protected JSplitPane createMainSplitPane() {
        this.mainSplitPane = this.createLeftRightSplitPane("ClsesTab.left_right", 250);
        this.resourcePanel = this.createResourcePanel();
        JComponent rightComponent = (JComponent)((Object)this.resourcePanel);
        this.hierarchiesPanel = new HierarchiesPanel(this);
        this.clsesPanel = (AssertedClassesPanel)((Object)this.createAssertedClsesPane());
        HierarchyPanel primaryPanel = new HierarchyPanel(this.clsesPanel, this.hierarchiesPanel, false, this.getOWLModel());
        this.hierarchiesPanel.addHierarchyPanel(primaryPanel);
        this.mainSplitPane.setLeftComponent(this.hierarchiesPanel);
        this.mainSplitPane.setRightComponent(rightComponent);
        this.mainSplitPane.setDividerLocation(250);
        return this.mainSplitPane;
    }

    public boolean displayHostResource(RDFResource resource) {
        if (resource instanceof RDFSNamedClass) {
            this.clsesPanel.setSelectedClass((RDFSNamedClass)resource);
            return true;
        }
        if (resource instanceof OWLAnonymousClass) {
            OWLAnonymousClass cls = (OWLAnonymousClass)resource;
            OWLAnonymousClass rootCls = cls.getExpressionRoot();
            Collection refs = this.getOWLModel().getReferences(rootCls, 100000);
            HashSet<Slot> ignoreSlots = new HashSet<Slot>();
            OWLModel owlModel = cls.getOWLModel();
            ignoreSlots.add(owlModel.getSlot(":DIRECT-TYPE"));
            ignoreSlots.add(owlModel.getRDFTypeProperty());
            ignoreSlots.add(owlModel.getSlot(":DIRECT-INSTANCES"));
            for (Reference reference : refs) {
                DisjointClassesWidget disjointClassesWidget;
                if (ignoreSlots.contains(reference.getSlot()) || !(reference.getFrame() instanceof RDFSNamedClass) || !reference.getFrame().isVisible()) continue;
                this.clsesPanel.setSelectedClass((RDFSNamedClass)reference.getFrame());
                ConditionsWidget conditionsWidget = this.getConditionsWidget();
                if (conditionsWidget != null) {
                    conditionsWidget.getCurrentConditionsWidget().getTable().setSelectedRow(rootCls);
                }
                if ((disjointClassesWidget = this.getDisjointClassesWidget()) != null) {
                    disjointClassesWidget.getTable().setSelectedRow(rootCls);
                }
                return true;
            }
        }
        return false;
    }

    public void ensureClsSelected(Cls cls, int oldConditionsRow) {
        this.ensureClassSelected((RDFSNamedClass)cls, oldConditionsRow);
    }

    public void ensureClassSelected(RDFSNamedClass cls, int oldConditionsRow) {
        if (cls != null && !this.clsesPanel.getSelection().contains(cls)) {
            ConditionsWidget newConditionsWidget;
            this.clsesPanel.setExpandedClass(cls, true);
            this.clsesPanel.setSelectedClass(cls);
            if (oldConditionsRow >= 0 && cls.equals(this.resourcePanel.getResource()) && (newConditionsWidget = this.getConditionsWidget()) != null) {
                newConditionsWidget.setSelectedRow(oldConditionsRow);
            }
        }
    }

    public static OWLClassesTab getOWLClassesTab(Component comp) {
        while (comp != null) {
            if (comp instanceof OWLClassesTab) {
                return (OWLClassesTab)((Object)comp);
            }
            comp = comp.getParent();
        }
        return null;
    }

    public static OWLClassesTab getClsesTab(Component comp) {
        return OWLClassesTab.getOWLClassesTab(comp);
    }

    public ConditionsWidget getConditionsWidget() {
        return (ConditionsWidget)((Object)OWLUI.findComponent((Container)((Object)this.resourcePanel), ConditionsWidget.class));
    }

    public JTree getClsTree() {
        return this.clsesPanel.getClsesTree();
    }

    public DisjointClassesWidget getDisjointClassesWidget() {
        return (DisjointClassesWidget)((Object)OWLUI.findComponent((Container)((Object)this.resourcePanel), DisjointClassesWidget.class));
    }

    protected HierarchiesPanel getHierarchiesPanel() {
        return this.hierarchiesPanel;
    }

    public HierarchyManager getHierarchyManager() {
        return this.hierarchiesPanel;
    }

    protected JSplitPane getMainSplitPane() {
        return this.mainSplitPane;
    }

    public Selectable getNestedSelectable() {
        return this.clsesPanel;
    }

    public OWLModel getOWLModel() {
        return (OWLModel)this.getProject().getKnowledgeBase();
    }

    protected ResourceDisplay getResourceDisplay() {
        return (ResourceDisplay)this.resourcePanel;
    }

    public ResourcePanel getResourcePanel() {
        return this.resourcePanel;
    }

    public RDFSNamedClass getSelectedClass() {
        Collection sels = this.clsesPanel.getSelection();
        if (sels.size() == 1) {
            return (RDFSNamedClass)sels.iterator().next();
        }
        return null;
    }

    public void hierarchiesChanged(int newPreferredWidth) {
        this.hierarchiesPanel.revalidate();
        this.mainSplitPane.setDividerLocation(newPreferredWidth);
        this.mainSplitPane.revalidate();
    }

    public void initialize() {
        this.setIcon(OWLIcons.getClassesIcon());
        this.setLabel("OWLClasses");
        this.mainSplitPane = this.createMainSplitPane();
        this.add(this.mainSplitPane);
        this.setInitialSelection();
        this.setClsTree(this.clsesPanel.getClsesTree());
    }

    public static boolean isSuitable(Project p, Collection errors) {
        if (!(p.getKnowledgeBase() instanceof OWLModel)) {
            errors.add("This tab can only be used with OWL projects.");
            return false;
        }
        return true;
    }

    public void refreshChangedClses() {
        ChangedClassesPanel ccp = ChangedClassesPanel.get(this.getOWLModel());
        ccp.refresh();
        if (ccp.getChangeCount() > 0) {
            ResultsPanelManager.addResultsPanel(this.getOWLModel(), ccp, true);
        }
        this.hierarchiesPanel.expandRootsOfInferredTrees();
    }

    protected void setMainSplitPane(JSplitPane splitpanel) {
        this.mainSplitPane = splitpanel;
    }

    protected void setHierarchiesPanel(HierarchiesPanel hierPanel) {
        this.hierarchiesPanel = hierPanel;
    }

    public void setInferredClsesVisible(boolean visible) {
        ProjectView projectView = ProtegeUI.getProjectView(this.getProject());
        projectView.setSelectedTab((TabWidget)this);
        if (visible) {
            this.hierarchiesPanel.showInferredHierarchy(this.getOWLModel());
        } else {
            this.hierarchiesPanel.closeInferredHierarchies();
        }
    }

    protected void setInitialSelection() {
        if (this.clsesPanel != null) {
            this.transmitSelection();
        }
    }

    public void setSelectedCls(OWLNamedClass cls) {
        this.clsesPanel.setSelectedClass(cls);
    }

    public void setSelectedCls(RDFSNamedClass aClass) {
        this.clsesPanel.setSelectedClass(aClass);
    }

    public void showCls(Cls cls) {
        if (cls instanceof RDFSNamedClass) {
            this.showClass((RDFSNamedClass)cls);
        }
    }

    public void showClass(RDFSNamedClass cls) {
        this.clsesPanel.setSelectedClass(cls);
    }

    public void showInferredHierarchy() {
        OWLModel owlModel = this.getOWLModel();
        InferredSubsumptionTreePanel inferredTreePanel = new InferredSubsumptionTreePanel(owlModel);
        this.hierarchiesPanel.addHierarchy(inferredTreePanel);
    }

    protected void transmitSelection() {
        OWLModel owlModel;
        Collection selection = this.clsesPanel.getSelection();
        Instance selectedInstance = null;
        if (selection.size() == 1 && ((selectedInstance = (Instance)CollectionUtilities.getFirstItem((Collection)selection)).equals((owlModel = this.getOWLModel()).getOWLNothing()) || selectedInstance.equals(owlModel.getRDFSNamedClass("rdfs:Literal")) || selectedInstance.equals(owlModel.getCls(":DIRECTED-BINARY-RELATION")) || selectedInstance.equals(owlModel.getRDFListClass()) || selectedInstance.equals(owlModel.getRDFUntypedResourcesClass()))) {
            selectedInstance = null;
        }
        if (selectedInstance == null || selectedInstance instanceof RDFResource) {
            this.resourcePanel.setResource((RDFResource)selectedInstance);
        } else if (this.resourcePanel instanceof ResourceDisplay) {
            ((ResourceDisplay)this.resourcePanel).setInstance(selectedInstance);
        }
    }
}

