/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionEditorComponent;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTextField;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.code.SymbolPanel;
import edu.stanford.smi.protegex.owl.ui.code.SymbolTextField;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableConstants;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableTransferHandler;
import edu.stanford.smi.protegex.owl.ui.conditions.PropertyConditionsDisplay;
import edu.stanford.smi.protegex.owl.ui.conditions.PropertySuggestionPopup;
import edu.stanford.smi.protegex.owl.ui.conditions.SeparatorCellRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.View;

public class ConditionsTable
extends OWLTable
implements ConditionsTableConstants,
PropertyConditionsDisplay {
    private SeparatorCellRenderer separatorCellRendererGrayed = new SeparatorCellRenderer(true);
    private ConditionsTableModel tableModel;
    private PropertySuggestionPopup propertyPopup;

    public ConditionsTable(OWLModel owlModel, ConditionsTableModel aTableModel) {
        super(aTableModel, owlModel, true);
        this.tableModel = aTableModel;
        this.setTransferHandler(new ConditionsTableTransferHandler(owlModel));
    }

    protected void addNavigationMenuItems(RDFResource resource, JPopupMenu menu) {
        super.addNavigationMenuItems(resource, menu);
        int row = this.getSelectedRow();
        if (this.tableModel.getType(row) == -2) {
            final OWLNamedClass definingClass = this.tableModel.getOriginClass(row);
            menu.add(new AbstractAction("Navigate to defining class (" + definingClass.getBrowserText() + ")", ProtegeUI.getIcon(definingClass)){

                public void actionPerformed(ActionEvent e) {
                    ConditionsTable.this.navigateTo(definingClass);
                }
            });
        }
    }

    public void addRestriction(OWLRestriction restriction) {
        this.addRow(restriction);
    }

    public int addRow(Cls cls) {
        if (cls.equals(this.tableModel.getEditedCls())) {
            this.tableModel.displaySemanticError("Cannot assign " + cls.getBrowserText() + " to itself.");
            return -1;
        }
        RDFSClass rdfsClass = (RDFSClass)cls;
        if (this.tableModel.addRow(rdfsClass, this.getSelectedRow())) {
            this.setSelectedRow(rdfsClass);
            return this.tableModel.getClassRow(rdfsClass);
        }
        this.tableModel.displaySemanticError("Could not add " + cls.getBrowserText() + ".");
        if (rdfsClass instanceof OWLAnonymousClass) {
            rdfsClass.delete();
        }
        return -1;
    }

    protected void showSymbolPanel(boolean errorFlag) {
        super.showSymbolPanel(errorFlag);
        this.showPropertyWindow();
    }

    protected void showPropertyWindow() {
        if (this.propertyPopup == null) {
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, (Component)((Object)this));
            this.propertyPopup = new PropertySuggestionPopup(window, this);
        }
        this.propertyPopup.showPopup(this.getEditedCls());
    }

    protected void hidePropertyWindow() {
        if (this.propertyPopup != null) {
            this.propertyPopup.hidePopup();
        }
    }

    public void createAndEditRow() {
        int selectedRow = this.getSelectedRow();
        this.createAndEditRow(selectedRow);
    }

    private void createAndEditRow(int selectedRow) {
        if (selectedRow >= 0 && this.tableModel.getType(selectedRow) != -2) {
            int row = this.tableModel.addEmptyRow(selectedRow);
            this.editExpression(row);
        }
    }

    protected ResourceRenderer createOWLFrameRenderer() {
        return new ResourceRenderer(){
            private Icon icon;
            private Cls originCls;

            protected void loadCls(Cls cls) {
                int row = ConditionsTable.this.tableModel.getClassRow((RDFSClass)cls);
                this.originCls = null;
                boolean grayed = false;
                if (cls instanceof OWLAnonymousClass && ConditionsTable.this.tableModel.getType(row) == -2) {
                    Icon baseIcon = cls.getIcon();
                    if (baseIcon instanceof ImageIcon) {
                        this.setMainIcon(OWLIcons.getInheritedClsIcon((ImageIcon)baseIcon));
                    } else {
                        this.setMainIcon(baseIcon);
                    }
                    super.loadClsAfterIcon(cls);
                    this.originCls = ConditionsTable.this.tableModel.getOriginClass(row);
                    grayed = true;
                } else {
                    super.loadCls(cls);
                }
                this.icon = ConditionsTable.this.tableModel.getIcon(row, ConditionsTable.this.getRowHeight());
                this.setGrayedText(grayed);
            }

            public void paint(Graphics g) {
                super.paint(g);
                int width = this.getWidth();
                if (this.icon != null) {
                    int x = width - this.icon.getIconWidth() - 3;
                    this.icon.paintIcon((Component)((Object)this), g, x, 1);
                    if (this.originCls != null) {
                        FontMetrics fm = this._fontMetrics;
                        int mainTextLength = fm.stringWidth(this.getMainText());
                        int ascent = fm.getAscent();
                        String browserText = this.originCls.getBrowserText();
                        String str = "[from " + browserText + "]";
                        int strWidth = fm.stringWidth(str);
                        int c = browserText.length();
                        while (c > 3 && x - strWidth - 2 <= mainTextLength + 26) {
                            str = "[from " + browserText.substring(0, --c) + "...]";
                            strWidth = fm.stringWidth(str);
                        }
                        if (x - strWidth - 2 > mainTextLength + 26) {
                            g.setColor(Color.gray);
                            g.drawString(str, x - strWidth - 2, ascent);
                        }
                    }
                }
            }

            public Component getTableCellRendererComponent(JTable jTable, Object o, boolean b, boolean b1, int i, int i1) {
                Component c = super.getTableCellRendererComponent(jTable, o, b, b1, i, i1);
                int prefHeight = c.getPreferredSize().height;
                if (jTable.getRowHeight(i) != prefHeight) {
                    SymbolPanel symbolPanel = ConditionsTable.this.getSymbolPanel();
                    jTable.setRowHeight(i, prefHeight);
                    symbolPanel.setLocation(symbolPanel.getX(), symbolPanel.getY() + prefHeight);
                    symbolPanel.repaint();
                }
                return c;
            }
        };
    }

    protected int getPreferredRowHeight(JTable table, SymbolEditorComponent editorComponent) {
        View v = editorComponent.getTextComponent().getUI().getRootView(editorComponent.getTextComponent());
        v.setSize(table.getWidth(), 2.1474836E9f);
        return (int)v.getPreferredSpan(1);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = super.createPopupMenu();
        int selectedRow = this.getSelectedRow();
        if (selectedRow >= 0 && this.tableModel.isDefinition(selectedRow)) {
            JMenuItem item = menu.add(new AbstractAction("Create new necessary & sufficient block", Icons.getBlankIcon()){

                public void actionPerformed(ActionEvent e) {
                    int row = ConditionsTable.this.tableModel.addEmptyDefinitionBlock();
                    ConditionsTable.this.setSelectedRow(row);
                }
            });
            menu.add((Component)item, 0);
            menu.add((Component)new JPopupMenu.Separator(), 1);
        }
        return menu;
    }

    protected SymbolTextField createSymbolTextField(OWLModel owlModel, SymbolErrorDisplay errorDisplay) {
        return new ClassDescriptionTextField(owlModel, errorDisplay);
    }

    protected SymbolEditorComponent createSymbolEditorComponent(OWLModel model, SymbolErrorDisplay errorDisplay) {
        return new ClassDescriptionEditorComponent(model, errorDisplay, true);
    }

    public void displayRowsWithProperty(OWLProperty property) {
        this.getOWLFrameRenderer().setFocusedFrame((Frame)property);
        this.repaint();
    }

    public void editingStopped(ChangeEvent e) {
        OWLClassesTab tab = this.getOWLClsesTab();
        super.editingStopped(e);
        if (this.tableModel.previouslyEditedCls != null) {
            this.setSelectedRow((RDFSClass)this.tableModel.previouslyEditedCls);
        }
        this.ensureEditedClassSelectedInExplorer(tab);
    }

    protected void editMultiLine() {
        OWLClassesTab tab = this.getOWLClsesTab();
        int oldRow = this.getSelectedRow();
        super.editMultiLine();
        if (tab != null) {
            tab.ensureClassSelected(this.tableModel.getEditedCls(), oldRow);
        }
    }

    public void ensureEditedClassSelectedInExplorer(OWLClassesTab owlClassesTab) {
        if (owlClassesTab != null) {
            OWLNamedClass editedCls = this.tableModel.getEditedCls();
            owlClassesTab.ensureClassSelected(editedCls, this.getSelectedRow());
        }
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 0 && this.tableModel.isSeparator(row)) {
            return this.separatorCellRendererGrayed;
        }
        return super.getCellRenderer(row, column);
    }

    public OWLClassesTab getOWLClsesTab() {
        Container parent = this.getParent();
        while (parent != null && !(parent instanceof OWLClassesTab)) {
            parent = parent.getParent();
        }
        return (OWLClassesTab)((Object)parent);
    }

    public List getPrototypeTriples() {
        int[] sels = this.getSelectedRows();
        if (sels.length == 1 && this.tableModel.isSeparator(sels[0])) {
            RDFProperty predicate = null;
            predicate = this.tableModel.isDefinition(sels[0]) ? this.getOWLModel().getOWLEquivalentClassProperty() : this.getOWLModel().getRDFSSubClassOfProperty();
            return Collections.singletonList(new DefaultTriple(this.tableModel.getEditedCls(), predicate, null));
        }
        return super.getPrototypeTriples();
    }

    public void hideSymbolPanel() {
        super.hideSymbolPanel();
        this.tableModel.removeEmptyRow();
        this.hidePropertyWindow();
    }

    protected boolean isTableHeaderHidden() {
        return true;
    }

    public void paint(Graphics g) {
        super.paint(g);
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            int count;
            if (this.tableModel.isSeparator(i) && this.tableModel.isDefinition(i) && (count = this.tableModel.getBlockSize(i + 1)) > 0) {
                this.paintEquivalentBlock(g, i + 1, count);
            }
            ++i;
        }
    }

    private void paintEquivalentBlock(Graphics g, int startIndex, int rowCount) {
        int width = this.getWidth();
        int rowHeight = this.getRowHeight();
        int rx = width - 35;
        int ry = rowHeight * startIndex + 1;
        int rw = 31;
        int rh = rowHeight * rowCount - 2;
        g.setColor(new Color(255, 200, 128));
        g.fillRect(rx, ry, 31, rh);
        g.setColor(new Color(110, 110, 110));
        g.drawRect(rx, ry, 31, rh);
        int middle = ry + rh / 2;
        g.setColor(Color.black);
        int lx1 = rx + 13;
        int lx2 = rx + 18;
        g.drawLine(lx1, middle - 2, lx2, middle - 2);
        g.drawLine(lx1, middle, lx2, middle);
        g.drawLine(lx1, middle + 2, lx2, middle + 2);
    }

    public void selectNecessaryIfNothingSelected() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow < 0) {
            selectedRow = 1;
            while (this.tableModel.getType(selectedRow) != -1) {
                ++selectedRow;
            }
            this.setSelectedRow(selectedRow);
        }
    }

    public void setSelectedTriples(Collection triples) {
        Triple triple;
        this.tableModel.refresh();
        Iterator it = triples.iterator();
        if (it.hasNext() && (triple = (Triple)it.next()).getObject() instanceof RDFSClass) {
            RDFSClass cls = (RDFSClass)triple.getObject();
            this.setSelectedRow(cls);
        }
    }

    public void setValueAt(Object aValue, int row, int column) {
        this.tableModel.previouslyEditedCls = null;
        if (aValue instanceof String) {
            try {
                String text = (String)aValue;
                this.getOWLModel().getOWLClassParser().checkClass(this.getOWLModel(), text);
                super.setValueAt(aValue, row, column);
                if (this.tableModel.previouslyEditedCls != null) {
                    this.setSelectedRow((RDFSClass)this.tableModel.previouslyEditedCls);
                }
            }
            catch (Exception ex) {
                Log.emptyCatchBlock((Throwable)ex);
            }
        }
    }
}

