/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.DocumentChangedListener;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.URIUtilities;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class URIField
extends JComponent {
    private JTextField _textField;
    private String _description;
    private String _extension;
    private ChangeListener _changeListener;

    public URIField(String string, URI uRI, String string2, String string3) {
        this._description = string3;
        this._extension = string2;
        this.setLayout(new BorderLayout());
        LabeledComponent labeledComponent = new LabeledComponent(string, this.createComponent(uRI));
        labeledComponent.addHeaderButton(new AbstractAction("Browse for File", Icons.getAddIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                URIField.this.browse();
            }
        });
        this.add(labeledComponent);
    }

    public void addChangeListener(ChangeListener changeListener) {
        Assert.assertNull("existing change listener", this._changeListener);
        this._changeListener = changeListener;
    }

    protected void browse() {
        JFileChooser jFileChooser = ComponentFactory.createFileChooser(this._description, this._extension);
        jFileChooser.setApproveButtonText("Select");
        int n = jFileChooser.showOpenDialog(this);
        switch (n) {
            case -1: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                this._textField.setText(jFileChooser.getSelectedFile().getPath());
                break;
            }
            default: {
                Assert.fail("bad result: " + n);
            }
        }
    }

    private JComponent createComponent(URI uRI) {
        this._textField = ComponentFactory.createTextField();
        this._textField.setColumns(40);
        this.setURI(uRI);
        this._textField.getDocument().addDocumentListener(new DocumentChangedListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                URIField.this.notifyListener();
            }
        });
        return this._textField;
    }

    public URI getAbsoluteURI() {
        String string = this._textField.getText();
        return URIUtilities.createURI(string);
    }

    public URI getRelativeURI() {
        URI uRI = null;
        String string = this._textField.getText().trim();
        if (string.length() > 0) {
            try {
                uRI = new URI(string);
            }
            catch (Exception exception) {
                File file = new File(string);
                try {
                    uRI = new URI(file.getName());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return uRI;
    }

    private void notifyListener() {
        if (this._changeListener != null) {
            this._changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public void setURI(URI uRI) {
        String string = uRI == null ? null : uRI.toString();
        this._textField.setText(string);
    }
}

