/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls.tests;

import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.cls.ConvertToDefinedClassAction;
import java.util.ArrayList;

public class ConvertToDefinedClsActionTestCase
extends AbstractJenaTestCase {
    public void testFailToConvertPrimitiveToDefinedIfOnlyThingIsSuperclass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        ConvertToDefinedClassAction.performAction(cls);
        ConvertToDefinedClsActionTestCase.assertNull((Object)cls.getDefinition());
    }

    public void testSimpleConvertPrimitiveToDefined() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("slot");
        property.setDomain(cls);
        cls.addSuperclass(this.owlModel.createOWLMinCardinality(property, 1));
        ConvertToDefinedClassAction.performAction(cls);
        ConvertToDefinedClsActionTestCase.assertSize(1, cls.getEquivalentClasses());
        ConvertToDefinedClsActionTestCase.assertTrue((boolean)(cls.getDefinition() instanceof OWLMinCardinality));
    }

    public void testConvertPrimitiveToDefinedWith2Operands() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("Super");
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Cls", superCls);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("slot");
        property.setDomain(cls);
        cls.addSuperclass(this.owlModel.createOWLMinCardinality(property, 1));
        ConvertToDefinedClassAction.performAction(cls);
        ConvertToDefinedClsActionTestCase.assertSize(1, cls.getEquivalentClasses());
        ConvertToDefinedClsActionTestCase.assertTrue((boolean)(cls.getDefinition() instanceof OWLIntersectionClass));
        OWLIntersectionClass intersectionCls = (OWLIntersectionClass)cls.getDefinition();
        ArrayList operands = new ArrayList(intersectionCls.getOperands());
        ConvertToDefinedClsActionTestCase.assertSize(2, operands);
        ConvertToDefinedClsActionTestCase.assertContains((Object)superCls, operands);
        operands.remove(superCls);
        ConvertToDefinedClsActionTestCase.assertTrue((boolean)(operands.iterator().next() instanceof OWLMinCardinality));
        ConvertToDefinedClsActionTestCase.assertTrue((boolean)cls.isSubclassOf(superCls));
        ConvertToDefinedClsActionTestCase.assertSize(2, cls.getSuperclasses(false));
    }
}

