/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.query;

import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.query.SPARQLOWLModelAction;
import edu.stanford.smi.protegex.owl.ui.query.SPARQLResultsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SPARQLQueryPanel
extends JPanel {
    private OWLModel owlModel;
    private JTextArea textArea;
    private static String TEXT = "SELECT ?subject ?object\nWHERE { ?subject rdfs:subClassOf ?object }";

    public SPARQLQueryPanel(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.textArea = new JTextArea(TEXT);
        OWLLabeledComponent lc = new OWLLabeledComponent("Query", new JScrollPane(this.textArea));
        JButton queryButton = new JButton("Execute Query");
        queryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SPARQLQueryPanel.this.executeQuery();
            }
        });
        lc.addHeaderButton(new AbstractAction("Assert matches for this query", OWLIcons.getImageIcon("AssertTrue")){

            public void actionPerformed(ActionEvent e) {
                SPARQLQueryPanel.this.handleAssertMatches("http://www.owl-ontologies.com/assert.owl#notEmpty", "http://www.owl-ontologies.com/assert.owl#empty");
            }
        });
        lc.addHeaderButton(new AbstractAction("Assert no matches for this query", OWLIcons.getImageIcon("AssertFalse")){

            public void actionPerformed(ActionEvent e) {
                SPARQLQueryPanel.this.handleAssertMatches("http://www.owl-ontologies.com/assert.owl#empty", "http://www.owl-ontologies.com/assert.owl#notEmpty");
            }
        });
        lc.setPreferredSize(new Dimension(300, 50));
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)lc));
        this.add("South", queryButton);
    }

    private boolean canAssert(String propertyURI) {
        String propertyName = this.owlModel.getResourceNameForURI(propertyURI);
        if (propertyName != null && this.owlModel.getRDFProperty(propertyName) != null) {
            if (ProtegeUI.getProjectView(this.owlModel.getProject()).getTabbedPane().getSelectedComponent() instanceof OWLClassesTab) {
                return true;
            }
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "You need to select a class in the OWLClasses tab\nbefore you can assert a query.");
            return false;
        }
        if (this.owlModel instanceof JenaOWLModel && ProtegeUI.getModalDialogFactory().showConfirmDialog(this, "You need to import the following ontology before you\ncan use the assert queries support:\nhttp://www.owl-ontologies.com/assert.owl\nShall this be added now?", "Missing import")) {
            try {
                this.owlModel.getNamespaceManager().setPrefix("http://www.owl-ontologies.com/assert.owl#", "assert");
                ImportHelper importHelper = new ImportHelper((JenaOWLModel)this.owlModel);
                importHelper.addImport(URI.create("http://www.owl-ontologies.com/assert.owl"));
                importHelper.importOntologies();
            }
            catch (Exception ex) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "Import failed: " + ex);
            }
        }
        return false;
    }

    private void executeQuery() {
        SPARQLResultsPanel resultsPanel = SPARQLOWLModelAction.show(this.owlModel, false);
        String queryText = this.getQueryText();
        resultsPanel.executeQuery(queryText);
    }

    public String getQueryText() {
        return this.textArea.getText();
    }

    private void handleAssertMatches(String propertyURI, String inversePropertyURI) {
        OWLClassesTab classesTab;
        RDFSNamedClass subject;
        if (this.canAssert(propertyURI) && (subject = (classesTab = (OWLClassesTab)ProtegeUI.getProjectView(this.owlModel.getProject()).getTabByClassName(OWLClassesTab.class.getName())).getSelectedClass()) != null) {
            String inversePropertyName;
            RDFProperty inverseProperty;
            String propertyName = this.owlModel.getResourceNameForURI(propertyURI);
            RDFProperty property = this.owlModel.getRDFProperty(propertyName);
            String queryText = this.getQueryText();
            if (!subject.getPropertyValues(property).contains(queryText)) {
                subject.addPropertyValue(property, queryText);
            }
            if ((inverseProperty = this.owlModel.getRDFProperty(inversePropertyName = this.owlModel.getResourceNameForURI(inversePropertyURI))) != null) {
                subject.removePropertyValue(inverseProperty, queryText);
            }
        }
    }

    public void rememberQueryText() {
        TEXT = this.getQueryText();
    }

    public void setQueryText(String str) {
        this.textArea.setText(str);
    }
}

