/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class SearchSettingsPanel
extends JPanel {
    private JCheckBox ignorePrefixesCheckBox = new JCheckBox("Ignore prefixes for searching");
    private SelectableList list;
    private OWLModel owlModel;

    public SearchSettingsPanel(final OWLModel owlModel) {
        this.owlModel = owlModel;
        this.list = new SelectableList();
        this.list.setListData(owlModel.getSearchSynonymProperties().toArray());
        this.list.setCellRenderer((ListCellRenderer)((Object)new ResourceRenderer()));
        OWLLabeledComponent lc = new OWLLabeledComponent("Use search synonyms", new JScrollPane((Component)this.list));
        lc.addHeaderButton(new AbstractAction("Add property...", OWLIcons.getAddIcon("RDFProperty")){

            public void actionPerformed(ActionEvent e) {
                SearchSettingsPanel.this.addProperty();
            }
        });
        lc.addHeaderButton((Action)new AllowableAction("Remove selected property", OWLIcons.getRemoveIcon("RDFProperty"), (Selectable)this.list){

            public void actionPerformed(ActionEvent e) {
                SearchSettingsPanel.this.removeSelectedProperty();
            }
        });
        this.setLayout(new BorderLayout());
        Boolean b = owlModel.getOWLProject().getSettingsMap().getBoolean("OWL-TOLERATE-PREFIXES-IN-SEARCH");
        this.ignorePrefixesCheckBox.setSelected(Boolean.TRUE.equals(b));
        this.ignorePrefixesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                owlModel.getOWLProject().getSettingsMap().setBoolean("OWL-TOLERATE-PREFIXES-IN-SEARCH", SearchSettingsPanel.this.ignorePrefixesCheckBox.isSelected());
            }
        });
        this.add("North", this.ignorePrefixesCheckBox);
        this.add("Center", (Component)((Object)lc));
    }

    private void addProperty() {
        Collection oldValues = this.owlModel.getSearchSynonymProperties();
        Collection properties = this.owlModel.getRDFProperties();
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            RDFProperty property = (RDFProperty)it.next();
            if (!oldValues.contains(property) && property.getValueType() == ValueType.STRING) continue;
            it.remove();
        }
        HashSet neo = new HashSet(oldValues);
        neo.addAll(ProtegeUI.getSelectionDialogFactory().selectResourcesFromCollection(this, this.owlModel, properties, "Add search properties..."));
        this.owlModel.setSearchSynonymProperties(neo);
        this.list.setListData(this.owlModel.getSearchSynonymProperties().toArray());
    }

    private void removeSelectedProperty() {
        Collection oldValues = this.owlModel.getSearchSynonymProperties();
        oldValues.removeAll(this.list.getSelection());
        this.owlModel.setSearchSynonymProperties(oldValues);
        this.list.setListData(this.owlModel.getSearchSynonymProperties().toArray());
    }
}

