/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaNormalizer;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class JenaDLConverter {
    private OntModel ontModel;

    public JenaDLConverter(OntModel oldModel, NamespaceManager nsm) {
        this.ontModel = Jena.cloneOntModel(oldModel);
        new JenaNormalizer(this.ontModel, null, nsm);
    }

    private void addSubClasses(Collection classes, OntClass ontClass) {
        if (!classes.contains(ontClass)) {
            classes.add(ontClass);
            ExtendedIterator it = ontClass.listSubClasses();
            while (it.hasNext()) {
                OntClass subClass = (OntClass)it.next();
                this.addSubClasses(classes, subClass);
            }
        }
    }

    private void convertAnnotationProperties() {
        for (AnnotationProperty property : Jena.set((Iterator)this.ontModel.listAnnotationProperties())) {
            this.removeRDFTypesFromAnnotationProperty(property);
            this.removeDomainFromAnnotationProperty(property);
            this.removeRangeFromAnnotationProperty(property);
        }
    }

    private void convertClassProperties() {
        this.convertClassProperties(OWL.Class);
        this.convertClassProperties(OWL.DatatypeProperty);
        this.convertClassProperties(OWL.ObjectProperty);
    }

    private void convertClassProperties(Resource metaClass) {
        ExtendedIterator it = this.ontModel.listObjectProperties();
        while (it.hasNext()) {
            ObjectProperty objectProperty = (ObjectProperty)it.next();
            if (!Jena.set((Iterator)objectProperty.listRange()).contains(metaClass)) continue;
            objectProperty.removeRange(metaClass);
            this.log("- Removed " + metaClass + " from range of property " + objectProperty);
        }
    }

    public OntModel convertOntModel() {
        this.convertAnnotationProperties();
        this.convertMetaclasses();
        this.convertClassProperties();
        this.removeFullPropertyValues();
        this.removeAnnotationsFromAnonymousClasses();
        return this.ontModel;
    }

    private void convertMetaclasses() {
        this.convertMetaclasses(OWL.Class);
        this.convertMetaclasses(OWL.DatatypeProperty);
        this.convertMetaclasses(OWL.ObjectProperty);
    }

    private void convertMetaclasses(Resource metaClass) {
        HashSet subClassesOfMetaClass = new HashSet();
        ExtendedIterator it = this.ontModel.listNamedClasses();
        while (it.hasNext()) {
            OntClass namedClass = (OntClass)it.next();
            if (!namedClass.hasSuperClass(metaClass)) continue;
            this.addSubClasses(subClassesOfMetaClass, namedClass);
        }
        for (Individual individual : Jena.set((Iterator)this.ontModel.listIndividuals())) {
            if (!subClassesOfMetaClass.contains(individual.getRDFType(true))) continue;
            individual.setRDFType(metaClass);
            this.log("* Set RDF type of class " + individual + " to " + metaClass);
            this.removeFullPropertyValues((Resource)individual);
        }
        for (OntClass ontClass : subClassesOfMetaClass) {
            ontClass.remove();
            this.log("- Removed metaclass " + ontClass);
        }
    }

    private void log(String msg) {
        System.out.println("[JenaDLConverter] " + msg);
    }

    private void removeAnnotationsFromAnonymousClasses() {
        Set ps = Jena.set((Iterator)this.ontModel.listAnnotationProperties());
        ps.add(RDFS.seeAlso);
        ps.add(RDFS.isDefinedBy);
        ps.add(OWL.versionInfo);
        ExtendedIterator it = this.ontModel.listClasses();
        while (it.hasNext()) {
            OntClass ontClass = (OntClass)it.next();
            if (!ontClass.isAnon()) continue;
            for (Property property : ps) {
                ontClass.removeAll(property);
            }
        }
    }

    private void removeDomainFromAnnotationProperty(AnnotationProperty property) {
        Property domainProperty = RDFS.domain;
        StmtIterator it = property.listProperties(domainProperty);
        while (it.hasNext()) {
            Statement stmt = it.nextStatement();
            this.log("- Removing domain " + stmt.getObject() + " from annotation property " + property);
            it.remove();
        }
    }

    private void removeFullPropertyValues() {
        this.removeFullPropertyValues((Iterator)this.ontModel.listNamedClasses());
        this.removeFullPropertyValues((Iterator)this.ontModel.listDatatypeProperties());
        this.removeFullPropertyValues((Iterator)this.ontModel.listObjectProperties());
        this.removeFullPropertyValues((Iterator)this.ontModel.listAnnotationProperties());
    }

    private void removeFullPropertyValues(Iterator it) {
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            this.removeFullPropertyValues(resource);
        }
    }

    private void removeFullPropertyValues(Resource resource) {
        for (Statement statement : Jena.set((Iterator)resource.listProperties())) {
            String namespace;
            Property property = statement.getPredicate();
            if (property.hasProperty(RDF.type, (RDFNode)OWL.AnnotationProperty) || (namespace = property.getNameSpace()).equals(OWL.getURI()) || namespace.equals(RDF.getURI()) || namespace.equals(RDFS.getURI())) continue;
            this.log("- Removed OWL Full property value " + statement);
            statement.remove();
        }
    }

    private void removeProtegeOntology() {
        boolean reload = false;
        ExtendedIterator it = this.ontModel.listOntologies();
        while (it.hasNext()) {
            Resource resource;
            Ontology ontology = (Ontology)it.next();
            if (!ontology.hasProperty(OWL.imports, (RDFNode)(resource = this.ontModel.getResource(ProtegeNames.FILE)))) continue;
            ontology.removeImport(resource);
            this.log("- Removed import of " + resource + " from ontology " + ontology);
            reload = true;
        }
        if (reload) {
            this.ontModel = Jena.cloneOntModel(this.ontModel);
        }
    }

    private void removeRangeFromAnnotationProperty(AnnotationProperty property) {
        Property rangeProperty = RDFS.range;
        StmtIterator it = property.listProperties(rangeProperty);
        while (it.hasNext()) {
            Statement stmt = it.nextStatement();
            this.log("- Removing range " + stmt.getObject() + " from annotation property " + property);
            RDFNode range = stmt.getObject();
            it.remove();
            if (!range.canAs(DataRange.class)) continue;
            this.log("- Removing DataRange " + range);
            ((DataRange)range.as(DataRange.class)).remove();
        }
    }

    private void removeRDFTypesFromAnnotationProperty(AnnotationProperty property) {
        Property typeProperty = RDF.type;
        StmtIterator it = property.listProperties(typeProperty);
        while (it.hasNext()) {
            Statement stmt = it.nextStatement();
            Resource type = (Resource)stmt.getObject();
            if (type.equals((Object)OWL.AnnotationProperty)) continue;
            this.log("- Removing type " + type + " from annotation property " + property);
            it.remove();
        }
    }
}

