/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.ui.matrix.AnnotationPropertyMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.DependentMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.DependentMatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.EditableMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixTable;
import edu.stanford.smi.protegex.owl.ui.matrix.NameMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.PrefixMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.SortableMatrixColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class MatrixTableModel
extends AbstractTableModel
implements Disposable {
    public static final int COL_NAME = 0;
    public static final int COL_PREFIX = 1;
    private List columns = new ArrayList();
    private MatrixFilter filter;
    private List instances = new ArrayList();
    private ModelListener modelListener = new ModelAdapter(){

        public void classCreated(RDFSClass cls) {
            MatrixTableModel.this.handleInstanceCreated(cls);
        }

        public void classDeleted(RDFSClass cls) {
            MatrixTableModel.this.handleInstanceDeleted(cls);
        }

        public void individualCreated(RDFResource resource) {
            MatrixTableModel.this.handleInstanceCreated(resource);
        }

        public void individualDeleted(RDFResource resource) {
            MatrixTableModel.this.handleInstanceDeleted(resource);
        }

        public void propertyCreated(RDFProperty property) {
            MatrixTableModel.this.handleInstanceCreated(property);
        }

        public void propertyDeleted(RDFProperty property) {
            MatrixTableModel.this.handleInstanceDeleted(property);
        }
    };
    private OWLModel owlModel;
    private int sortColumn = 0;
    private MatrixTable table;

    public MatrixTableModel(OWLModel owlModel, MatrixFilter filter) {
        this.owlModel = owlModel;
        this.filter = filter;
        this.addDefaultColumns();
        owlModel.addModelListener(this.modelListener);
        this.addInstances();
    }

    public void addColumn(MatrixColumn column) {
        this.columns.add(column);
    }

    void addColumn(MatrixColumn column, int index) {
        this.columns.add(index, column);
    }

    protected void addDefaultColumns() {
        this.addColumn(new NameMatrixColumn());
        this.addColumn(new PrefixMatrixColumn());
    }

    private void addInstances() {
        this.instances.addAll(this.filter.getInitialValues());
        this.sortInstances();
    }

    public void dispose() {
        this.owlModel.removeModelListener(this.modelListener);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Class getColumnClass(int columnIndex) {
        return RDFResource.class;
    }

    public String getColumnName(int column) {
        MatrixColumn matrixColumn = this.getMatrixColumn(column);
        String str = matrixColumn.getName();
        if (str != null && column == this.sortColumn) {
            str = "[" + str + "]";
        }
        return str;
    }

    private int getIndexFor(RDFResource instance) {
        SortableMatrixColumn matrixColumn = this.getSortableMatrixColumn();
        Comparator c = matrixColumn.getSortComparator();
        int index = Collections.binarySearch(this.instances, instance, c);
        if (index >= 0) {
            return index;
        }
        return -index - 1;
    }

    public RDFResource getInstance(int row) {
        return (RDFResource)this.instances.get(row);
    }

    public MatrixColumn getMatrixColumn(int column) {
        return (MatrixColumn)this.columns.get(column);
    }

    public int getNewColumnIndex(MatrixColumn col) {
        return this.columns.size();
    }

    public int getRowCount() {
        return this.instances.size();
    }

    private SortableMatrixColumn getSortableMatrixColumn() {
        return (SortableMatrixColumn)this.getMatrixColumn(this.sortColumn);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getInstance(rowIndex);
    }

    public Collection getVisibleAnnotationProperties() {
        ArrayList<RDFProperty> results = new ArrayList<RDFProperty>();
        for (Object col : this.columns) {
            if (!(col instanceof AnnotationPropertyMatrixColumn)) continue;
            results.add(((AnnotationPropertyMatrixColumn)col).getAnnotationProperty());
        }
        return results;
    }

    private void handleInstanceCreated(Instance instance) {
        RDFResource RDFResource2;
        if (instance instanceof RDFResource && this.filter.isSuitable(RDFResource2 = (RDFResource)instance)) {
            int index = this.getIndexFor(RDFResource2);
            this.instances.add(index, RDFResource2);
            this.fireTableRowsInserted(index, index);
        }
    }

    private void handleInstanceDeleted(RDFResource instance) {
        if (this.isDependentOn(instance)) {
            this.table.close();
        } else {
            this.removeDependentColumns(instance);
            int index = this.instances.indexOf(instance);
            if (index >= 0) {
                this.instances.remove(index);
                this.fireTableRowsDeleted(index, index);
            }
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        RDFResource instance;
        MatrixColumn col = this.getMatrixColumn(columnIndex);
        if (col instanceof EditableMatrixColumn && (instance = this.getInstance(rowIndex)).isEditable()) {
            return ((EditableMatrixColumn)col).isCellEditable(instance);
        }
        return false;
    }

    protected boolean isDependentOn(RDFResource instance) {
        if (this.filter instanceof DependentMatrixFilter) {
            return ((DependentMatrixFilter)this.filter).isDependentOn(instance);
        }
        return false;
    }

    public boolean isSortableColumn(int column) {
        return this.getMatrixColumn(column) instanceof SortableMatrixColumn;
    }

    public void refill() {
        this.instances.clear();
        this.addInstances();
        this.fireTableDataChanged();
    }

    private void removeDependentColumns(RDFResource RDFResource2) {
        for (MatrixColumn column : new ArrayList(this.columns)) {
            if (!(column instanceof DependentMatrixColumn) || !((DependentMatrixColumn)column).isDependentOn(RDFResource2)) continue;
            this.removeColumn(column);
        }
    }

    private void removeColumn(MatrixColumn column) {
        int index = this.columns.indexOf(column);
        this.columns.remove(index);
        this.fireTableStructureChanged();
        this.table.initColumns();
    }

    public void setSortColumn(int column) {
        if (column != this.sortColumn) {
            this.sortColumn = column;
            this.sortInstances();
            this.fireTableStructureChanged();
        }
    }

    void setTable(MatrixTable table) {
        this.table = table;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        MatrixColumn col = this.getMatrixColumn(columnIndex);
        if (col instanceof EditableMatrixColumn) {
            RDFResource instance = this.getInstance(rowIndex);
            ((EditableMatrixColumn)col).setValueAt(instance, value);
        }
    }

    private void sortInstances() {
        SortableMatrixColumn c = this.getSortableMatrixColumn();
        Collections.sort(this.instances, c.getSortComparator());
    }
}

