/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGError;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasoner;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DefaultDIGReasoner;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.logger.DIGLogger;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.logger.DIGLoggerListener;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ErrorMessageLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogger;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ClassifyTaxonomyTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.GetAncestorConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.GetConceptIntersectionSuperclassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.GetConceptSatisfiableTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.GetDescendantConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.GetEquivalentConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.GetIndividualInferredTypesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.GetIndividualsBelongingToConceptTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.GetSubConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.GetSubsumptionRelationshipTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.GetSuperConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.IsConceptIntersectionSatisfiableTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.IsDisjointToTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.IsSubsumedByTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskAdapter;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskEvent;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskListener;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.SynchronizeReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.UpdateEquivalentClassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.UpdateInconsistentClassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.UpdateInferredHierarchyTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.UpdateInferredTypesTask;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceAdapter;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultProtegeOWLReasoner
implements ProtegeOWLReasoner {
    private static transient Logger log = Log.getLogger(DefaultProtegeOWLReasoner.class);
    private DIGReasoner reasoner;
    private OWLModel model;
    private boolean synchronizeReasoner = true;
    private boolean autoSynchReasoner = true;
    private String kbURI;
    private ProjectListener projectListener = new ProjectAdapter(){

        public void projectClosed(ProjectEvent event) {
            if (DefaultProtegeOWLReasoner.this.kbURI != null) {
                try {
                    DefaultProtegeOWLReasoner.this.reasoner.releaseKnowledgeBase(DefaultProtegeOWLReasoner.this.kbURI);
                    DefaultProtegeOWLReasoner.this.kbURI = null;
                    DefaultProtegeOWLReasoner.this.removeListeners();
                    DefaultProtegeOWLReasoner.this.model.getProject().removeProjectListener(DefaultProtegeOWLReasoner.this.projectListener);
                    DefaultProtegeOWLReasoner.this.model = null;
                }
                catch (DIGReasonerException e) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught", e);
                }
            }
        }
    };
    private ModelListener modelListener = new ModelAdapter(){

        public void classCreated(RDFSClass cls) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void classDeleted(RDFSClass cls) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void propertyCreated(RDFProperty property) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void propertyDeleted(RDFProperty property) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void individualCreated(RDFResource resource) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void individualDeleted(RDFResource resource) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }
    };
    private ResourceAdapter resourceAdapter = new ResourceAdapter(){

        public void typeAdded(RDFResource resource, RDFSClass type) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void typeRemoved(RDFResource resource, RDFSClass type) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }
    };
    private PropertyListener propertyListener = new PropertyAdapter(){

        public void subpropertyAdded(RDFProperty property, RDFProperty subproperty) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void subpropertyRemoved(RDFProperty property, RDFProperty subproperty) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void superpropertyAdded(RDFProperty property, RDFProperty superproperty) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void superpropertyRemoved(RDFProperty property, RDFProperty superproperty) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void unionDomainClassAdded(RDFProperty property, RDFSClass rdfsClass) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void unionDomainClassRemoved(RDFProperty property, RDFSClass rdfsClass) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }
    };
    private ClassListener classListener = new ClassAdapter(){

        public void addedToUnionDomainOf(RDFSClass cls, RDFProperty property) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void instanceAdded(RDFSClass cls, RDFResource instance) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void instanceRemoved(RDFSClass cls, RDFResource instance) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void removedFromUnionDomainOf(RDFSClass cls, RDFProperty property) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void subclassAdded(RDFSClass cls, RDFSClass subclass) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void subclassRemoved(RDFSClass cls, RDFSClass subclass) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void superclassAdded(RDFSClass cls, RDFSClass superclass) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void superclassRemoved(RDFSClass cls, RDFSClass superclass) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }
    };
    private PropertyValueListener propertyValueListener = new PropertyValueAdapter(){

        public void nameChanged(RDFResource resource, String oldName) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void propertyValueChanged(RDFResource resource, RDFProperty property, Collection oldValues) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }
    };
    private DIGLoggerListener digLoggerListener = new DIGLoggerListener(){

        public void errorLogged(DIGError error) {
            OWLNamedClass cause = DefaultProtegeOWLReasoner.this.model.getOWLNamedClass(error.getID());
            ReasonerLogger.getInstance().postLogRecord(new ErrorMessageLogRecord(cause, error.getMessage(), null));
        }
    };

    public DefaultProtegeOWLReasoner(OWLModel kb) {
        this.reasoner = new DefaultDIGReasoner();
        DIGLogger.getInstance(this.reasoner).addListener(this.digLoggerListener);
        this.setKnowledgeBase(kb);
        kb.getProject().addProjectListener(this.projectListener);
    }

    public DIGReasoner getDIGReasoner() {
        return this.reasoner;
    }

    protected void setKnowledgeBase(OWLModel kb) {
        if (this.model != null) {
            this.removeListeners();
        }
        this.model = kb;
        this.forceReasonerReSynchronization();
        this.addListeners();
    }

    private void removeListeners() {
        this.model.removeModelListener(this.modelListener);
        this.model.removeResourceListener(this.resourceAdapter);
        this.model.removePropertyListener(this.propertyListener);
        this.model.removeClassListener(this.classListener);
        this.model.removePropertyValueListener(this.propertyValueListener);
    }

    private void addListeners() {
        this.model.addModelListener(this.modelListener);
        this.model.addResourceListener(this.resourceAdapter);
        this.model.addPropertyListener(this.propertyListener);
        this.model.addClassListener(this.classListener);
        this.model.addPropertyValueListener(this.propertyValueListener);
    }

    public void setURL(String url) {
        try {
            if (!this.reasoner.getReasonerURL().equals(url)) {
                if (this.kbURI != null) {
                    this.reasoner.releaseKnowledgeBase(this.kbURI);
                    this.kbURI = null;
                    this.forceReasonerReSynchronization();
                }
                this.reasoner.setReasonerURL(url);
            }
        }
        catch (DIGReasonerException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public String getURL() {
        return this.reasoner.getReasonerURL();
    }

    public boolean isConnected() {
        try {
            this.reasoner.getIdentity();
            return true;
        }
        catch (DIGReasonerException ex) {
            return false;
        }
    }

    private void reactToKnowledgeBaseChange() {
        if (this.autoSynchReasoner) {
            this.forceReasonerReSynchronization();
        }
    }

    public void forceReasonerReSynchronization() {
        this.synchronizeReasoner = true;
    }

    public void setAutoSynchronizationEnabled(boolean b) {
        this.autoSynchReasoner = b;
    }

    public boolean isAutoSynchronizationEnabled() {
        return this.autoSynchReasoner;
    }

    public String getReasonerKnowledgeBaseURI() {
        return this.kbURI;
    }

    public void synchronizeReasoner(ReasonerTaskListener taskListener) throws DIGReasonerException {
        if (this.synchronizeReasoner || this.kbURI == null) {
            SynchronizeReasonerTask synchronizeReasonerTask = new SynchronizeReasonerTask(this);
            if (taskListener != null) {
                synchronizeReasonerTask.addTaskListener(taskListener);
            }
            if (this.kbURI == null) {
                this.kbURI = this.reasoner.createKnowledgeBase();
            }
            synchronizeReasonerTask.run();
            if (taskListener != null) {
                synchronizeReasonerTask.removeTaskListener(taskListener);
            }
            this.synchronizeReasoner = false;
        }
    }

    public DIGReasonerIdentity getIdentity() {
        DIGReasonerIdentity id;
        block2: {
            id = null;
            try {
                id = this.reasoner.getIdentity();
            }
            catch (DIGReasonerException e) {
                Log.getLogger().severe(e.getMessage());
                if (!log.isLoggable(Level.FINE)) break block2;
                log.log(Level.FINE, "Exception caught", e);
            }
        }
        return id;
    }

    public OWLModel getKnowledgeBase() {
        return this.model;
    }

    public void classifyTaxonomy(ReasonerTaskListener taskListener) throws DIGReasonerException {
        ClassifyTaxonomyTask task = new ClassifyTaxonomyTask(this);
        this.performTask(task, taskListener);
    }

    public void computeInferredHierarchy(ReasonerTaskListener taskListener) throws DIGReasonerException {
        UpdateInferredHierarchyTask task = new UpdateInferredHierarchyTask(this);
        this.performTask(task, taskListener);
    }

    public void computeEquivalentConcepts(ReasonerTaskListener taskListener) throws DIGReasonerException {
        UpdateEquivalentClassesTask task = new UpdateEquivalentClassesTask(this);
        this.performTask(task, taskListener);
    }

    public void computeInconsistentConcepts(ReasonerTaskListener taskListener) throws DIGReasonerException {
        UpdateInconsistentClassesTask task = new UpdateInconsistentClassesTask(this);
        this.performTask(task, taskListener);
    }

    public void computeInferredIndividualTypes(ReasonerTaskListener taskListener) throws DIGReasonerException {
        UpdateInferredTypesTask task = new UpdateInferredTypesTask(this);
        this.performTask(task, taskListener);
    }

    public boolean isSatisfiable(OWLClass aClass, ReasonerTaskListener taskListener) throws DIGReasonerException {
        GetConceptSatisfiableTask task = new GetConceptSatisfiableTask(aClass, this);
        this.performTask(task, taskListener);
        return task.getResult();
    }

    public boolean isIntersectionSatisfiable(OWLClass[] clses, ReasonerTaskListener taskListener) throws DIGReasonerException {
        IsConceptIntersectionSatisfiableTask task = new IsConceptIntersectionSatisfiableTask(clses, this);
        this.performTask(task, taskListener);
        return task.getResult();
    }

    public boolean isSubsumedBy(OWLClass cls1, OWLClass cls2, ReasonerTaskListener taskListener) throws DIGReasonerException {
        IsSubsumedByTask task = new IsSubsumedByTask(this, cls1, cls2);
        this.performTask(task, taskListener);
        return task.getResult();
    }

    public boolean isDisjointTo(OWLClass cls1, OWLClass cls2, ReasonerTaskListener taskListener) throws DIGReasonerException {
        IsDisjointToTask task = new IsDisjointToTask(this, cls1, cls2);
        this.performTask(task, taskListener);
        return task.getResult();
    }

    public int getSubsumptionRelationship(OWLClass cls1, OWLClass cls2, ReasonerTaskListener taskListener) throws DIGReasonerException {
        GetSubsumptionRelationshipTask task = new GetSubsumptionRelationshipTask(this, cls1, cls2);
        this.performTask(task, taskListener);
        return task.getResult();
    }

    public Collection getSuperclasses(OWLClass aClass, ReasonerTaskListener taskListener) throws DIGReasonerException {
        GetSuperConceptsTask task = new GetSuperConceptsTask(aClass, this);
        this.performTask(task, taskListener);
        return task.getResult();
    }

    public Collection getSuperclassesOfIntersection(OWLClass[] clses, ReasonerTaskListener taskListener) throws DIGReasonerException {
        GetConceptIntersectionSuperclassesTask task = new GetConceptIntersectionSuperclassesTask(clses, this);
        this.performTask(task, taskListener);
        return task.getResult();
    }

    public Collection getSubclasses(OWLClass aClass, ReasonerTaskListener taskListener) throws DIGReasonerException {
        GetSubConceptsTask task = new GetSubConceptsTask(aClass, this);
        this.performTask(task, taskListener);
        return task.getResult();
    }

    public Collection getAncestorClasses(OWLClass aClass, ReasonerTaskListener taskListener) throws DIGReasonerException {
        GetAncestorConceptsTask task = new GetAncestorConceptsTask(aClass, this);
        this.performTask(task, taskListener);
        return task.getResult();
    }

    public Collection getDescendantClasses(OWLClass aClass, ReasonerTaskListener taskListener) throws DIGReasonerException {
        GetDescendantConceptsTask task = new GetDescendantConceptsTask(aClass, this);
        this.performTask(task, taskListener);
        return task.getResult();
    }

    public Collection getEquivalentClasses(OWLClass aClass, ReasonerTaskListener taskListener) throws DIGReasonerException {
        GetEquivalentConceptsTask task = new GetEquivalentConceptsTask(aClass, this);
        this.performTask(task, taskListener);
        return task.getResult();
    }

    public Collection getIndividualsBelongingToClass(OWLClass aClass, ReasonerTaskListener taskListener) throws DIGReasonerException {
        GetIndividualsBelongingToConceptTask task = new GetIndividualsBelongingToConceptTask(aClass, this);
        this.performTask(task, taskListener);
        return task.getResult();
    }

    public Collection getIndividualTypes(OWLIndividual individual, ReasonerTaskListener taskListener) throws DIGReasonerException {
        GetIndividualInferredTypesTask task = new GetIndividualInferredTypesTask(individual, this);
        this.performTask(task, taskListener);
        return task.getResult();
    }

    public void performTask(ReasonerTask task, ReasonerTaskListener taskListener) throws DIGReasonerException {
        TimeDifference td = new TimeDifference();
        td.markStart();
        final ReasonerTaskListener tskLsnr = taskListener;
        ReasonerTaskAdapter taskAdapter = taskListener != null ? new ReasonerTaskAdapter(){

            public void addedToTask(ReasonerTaskEvent event) {
                tskLsnr.addedToTask(event);
            }

            public void progressChanged(ReasonerTaskEvent event) {
                tskLsnr.progressChanged(event);
            }

            public void progressIndeterminateChanged(ReasonerTaskEvent event) {
                tskLsnr.progressIndeterminateChanged(event);
            }

            public void descriptionChanged(ReasonerTaskEvent event) {
                tskLsnr.descriptionChanged(event);
            }

            public void messageChanged(ReasonerTaskEvent event) {
                tskLsnr.messageChanged(event);
            }

            public void taskFailed(ReasonerTaskEvent event) {
                tskLsnr.taskFailed(event);
            }
        } : new ReasonerTaskAdapter();
        this.synchronizeReasoner(taskAdapter);
        if (taskListener != null) {
            task.addTaskListener(taskListener);
        }
        try {
            try {
                task.run();
            }
            catch (DIGReasonerException e) {
                String oldKbURI = this.kbURI;
                this.kbURI = null;
                this.reasoner.releaseKnowledgeBase(oldKbURI);
                this.synchronizeReasoner = true;
                throw e;
            }
        }
        finally {
            if (taskListener != null) {
                task.removeTaskListener(taskListener);
            }
        }
        td.markEnd();
        ReasonerLogger.getInstance().postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Total time: " + td, null));
    }
}

