/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTable;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.DeleteRowAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public abstract class ClassDescriptionWidget
extends AbstractPropertyWidget {
    private ClassDescriptionTable table;
    private OWLTableAction viewAction = new AbstractOWLTableAction("View/edit class", Icons.getViewIcon()){

        public void actionPerformed(ActionEvent e) {
            Cls cls = ClassDescriptionWidget.this.table.getSelectedCls();
            if (cls != null) {
                ClassDescriptionWidget.this.showInstance((Instance)cls);
            }
        }

        public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
            return cls instanceof OWLNamedClass;
        }
    };

    protected abstract ResourceSelectionAction createAddAction(ClassDescriptionTable var1);

    protected abstract Action createCreateAction(ClassDescriptionTable var1);

    protected abstract Icon createHeaderIcon();

    protected abstract List createCustomActions(ClassDescriptionTable var1);

    protected abstract OWLTableModel createTableModel();

    public void dispose() {
        ((OWLTableModel)this.table.getModel()).dispose();
        super.dispose();
    }

    public OWLNamedClass getEditedCls() {
        return this.table.getEditedCls();
    }

    protected OWLLabeledComponent getLabeledComponent() {
        return (OWLLabeledComponent)((Object)this.getComponent(0));
    }

    protected abstract String getLabelText();

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public ClassDescriptionTable getTable() {
        return this.table;
    }

    public void initialize() {
        OWLTableModel tableModel = this.createTableModel();
        OWLModel owlModel = (OWLModel)this.getProject().getKnowledgeBase();
        this.table = new ClassDescriptionTable(owlModel, tableModel);
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.table));
        JViewport viewPort = scrollPane.getViewport();
        viewPort.setBackground(this.table.getBackground());
        OWLLabeledComponent labeledComponent = new OWLLabeledComponent(this.getLabelText(), scrollPane, true, true);
        Icon headerIcon = this.createHeaderIcon();
        if (headerIcon != null) {
            labeledComponent.setHeaderIcon(headerIcon);
        }
        WidgetUtilities.addViewButton(labeledComponent, this.viewAction);
        labeledComponent.addHeaderButton(this.createCreateAction(this.table));
        ResourceSelectionAction addAction = this.createAddAction(this.table);
        labeledComponent.addHeaderButton(addAction);
        this.table.registerAction(this.viewAction);
        for (Action action : this.createCustomActions(this.table)) {
            labeledComponent.addHeaderButton(action);
            if (!(action instanceof OWLTableAction)) continue;
            this.table.registerAction((OWLTableAction)action);
        }
        DeleteRowAction deleteAction = new DeleteRowAction(this.table);
        labeledComponent.addHeaderButton(deleteAction);
        this.table.registerAction(deleteAction);
        this.table.registerActionSeparator();
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)labeledComponent));
    }

    public void setInstance(Instance newInstance) {
        super.setInstance(newInstance);
        if (newInstance instanceof OWLNamedClass) {
            this.table.setCls((OWLNamedClass)newInstance);
        } else {
            this.table.setCls(null);
        }
    }
}

