/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.ClosureUtils;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SimpleStringMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryFrameDbAlt
implements NarrowFrameStore {
    private static Logger log = Log.getLogger(InMemoryFrameDbAlt.class);
    private String name;
    private int flushCount = 0;
    private FrameFactory ff;
    private int projectId = FrameID.allocateMemoryProjectPart();
    private int counter = 10000;
    private Map<FrameID, FrameValue> frames = new HashMap<FrameID, FrameValue>();
    private Map<FrameSlotRequest, List<Value>> valueMap = new HashMap<FrameSlotRequest, List<Value>>();

    public InMemoryFrameDbAlt(String string) {
        this.name = string;
    }

    public void setFrameFactory(FrameFactory frameFactory) {
        this.ff = frameFactory;
    }

    public void flush() {
        ++this.flushCount;
    }

    public void setJavaType(FrameID frameID, int n) {
        FrameValue frameValue = this.getFrameValue(frameID, true);
        frameValue.setJavaType(n);
    }

    private FrameValue getFrameValue(Frame frame) {
        FrameValue frameValue = this.frames.get(frame.getFrameID());
        if (frameValue == null) {
            frameValue = new FrameValue(frame);
            this.frames.put(frame.getFrameID(), frameValue);
            return frameValue;
        }
        frameValue.setFrame(frame);
        return frameValue;
    }

    private FrameValue getFrameValue(FrameID frameID, boolean bl) {
        FrameValue frameValue = this.frames.get(frameID);
        if (bl && frameValue == null) {
            frameValue = new FrameValue(frameID);
            this.frames.put(frameID, frameValue);
        }
        return frameValue;
    }

    private List<Value> getValues(Frame frame, Slot slot, Facet facet, boolean bl, boolean bl2) {
        return this.getValues(frame.getFrameID(), slot.getFrameID(), facet != null ? facet.getFrameID() : null, bl, bl2);
    }

    private List<Value> getValues(FrameID frameID, FrameID frameID2, FrameID frameID3, boolean bl, boolean bl2) {
        FrameSlotRequest frameSlotRequest = new FrameSlotRequest(frameID, frameID2, frameID3, bl);
        List<Value> list = this.valueMap.get(frameSlotRequest);
        if (bl2 && list == null) {
            list = new ArrayList<Value>();
            this.valueMap.put(frameSlotRequest, list);
        }
        return list;
    }

    private void setValues(Frame frame, Slot slot, Facet facet, boolean bl, List<Value> list) {
        this.setValues(frame.getFrameID(), slot.getFrameID(), facet != null ? facet.getFrameID() : null, bl, list);
    }

    private void setValues(FrameID frameID, FrameID frameID2, FrameID frameID3, boolean bl, List<Value> list) {
        if (list == null) {
            list = new ArrayList<Value>();
        }
        FrameSlotRequest frameSlotRequest = new FrameSlotRequest(frameID, frameID2, frameID3, bl);
        this.valueMap.put(frameSlotRequest, list);
    }

    private List<Value> buildValues(Collection collection) {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        for (Object e : collection) {
            if (e instanceof Frame) {
                arrayList.add(this.getFrameValue((Frame)e));
                continue;
            }
            arrayList.add(new Value(e));
        }
        return arrayList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return null;
    }

    @Override
    public FrameID generateFrameID() {
        return FrameID.createLocal(this.projectId, this.counter++);
    }

    @Override
    public int getFrameCount() {
        return this.frames.size();
    }

    @Override
    public int getClsCount() {
        return this.getCountByType(6);
    }

    @Override
    public int getSlotCount() {
        return this.getCountByType(7);
    }

    @Override
    public int getFacetCount() {
        return this.getCountByType(8);
    }

    @Override
    public int getSimpleInstanceCount() {
        return this.getCountByType(5);
    }

    public int getCountByType(int n) {
        int n2 = 0;
        for (FrameValue frameValue : this.frames.values()) {
            if (frameValue.getJavaType() != n) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public Set<Frame> getFrames() {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        for (FrameValue frameValue : this.frames.values()) {
            hashSet.add(frameValue.getObject());
        }
        return hashSet;
    }

    @Override
    public Frame getFrame(FrameID frameID) {
        FrameValue frameValue = this.getFrameValue(frameID, false);
        if (frameValue != null) {
            return frameValue.getObject();
        }
        return null;
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Entering getValues with frame id = " + frame.getFrameID() + " slot id = " + slot.getFrameID() + " facet id = " + (facet != null ? facet.getFrameID() : (FrameID)null) + " isTemplate = " + bl);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<Value> list = this.getValues(frame, slot, facet, bl, false);
        if (list == null) {
            return arrayList;
        }
        for (Value value : list) {
            arrayList.add(value.getObject());
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Results = [");
            for (Value value : arrayList) {
                if (value instanceof Frame) {
                    log.fine(((Frame)((Object)value)).getFrameID().toString() + "/ Frame");
                } else {
                    log.fine(((Object)value).toString() + "/" + value.getClass());
                }
                log.fine(", ");
            }
            log.fine("]");
        }
        return arrayList;
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl) {
        List<Value> list = this.getValues(frame, slot, facet, bl, false);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        List<Value> list = this.getValues(frame, slot, facet, bl, true);
        list.addAll(this.buildValues(collection));
        this.setValues(frame, slot, facet, bl, list);
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        if (n == n2 || n < 0 || n2 < 0) {
            return;
        }
        List<Value> list = this.getValues(frame, slot, facet, bl, true);
        if (n >= list.size() || n2 >= list.size()) {
            return;
        }
        Value value = list.remove(n);
        list.add(n2, value);
        this.setValues(frame, slot, facet, bl, list);
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        int n = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List<Value> list = this.getValues(frame, slot, facet, bl, false);
        if (list == null) {
            return;
        }
        for (Value value : list) {
            if (value.getObject().equals(object)) {
                arrayList.add(n);
            }
            ++n;
        }
        Collections.reverse(arrayList);
        Iterator<Value> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)((Object)iterator.next());
            list.remove(n2);
        }
        this.setValues(frame, slot, facet, bl, list);
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        this.getFrameValue(frame);
        this.setValues(frame, slot, facet, bl, this.buildValues(collection));
    }

    @Override
    public Set<Frame> getFrames(Slot slot, Facet facet, boolean bl, Object object) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        FrameID frameID = slot.getFrameID();
        FrameID frameID2 = null;
        if (facet != null) {
            frameID2 = facet.getFrameID();
        }
        for (FrameID frameID3 : this.frames.keySet()) {
            boolean bl2 = false;
            List<Value> list = this.getValues(frameID3, frameID, frameID2, bl, false);
            if (list == null) continue;
            for (Value value : list) {
                if (!value.getObject().equals(object)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            hashSet.add(this.frames.get(frameID3).getObject());
        }
        return hashSet;
    }

    @Override
    public Set<Frame> getFramesWithAnyValue(Slot slot, Facet facet, boolean bl) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        FrameID frameID = slot.getFrameID();
        FrameID frameID2 = null;
        if (facet != null) {
            frameID2 = facet.getFrameID();
        }
        for (FrameID frameID3 : this.frames.keySet()) {
            List<Value> list = this.getValues(frameID3, frameID, frameID2, bl, false);
            if (list == null || list.isEmpty()) continue;
            hashSet.add(this.frames.get(frameID3).getObject());
        }
        return hashSet;
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        FrameID frameID = slot.getFrameID();
        FrameID frameID2 = null;
        if (facet != null) {
            frameID2 = facet.getFrameID();
        }
        SimpleStringMatcher simpleStringMatcher = new SimpleStringMatcher(string);
        for (FrameID frameID3 : this.frames.keySet()) {
            boolean bl2 = false;
            List<Value> list = this.getValues(frameID3, frameID, frameID2, bl, false);
            if (list == null) continue;
            for (Value value : list) {
                String string2;
                if (!(value.getObject() instanceof String) || !simpleStringMatcher.isMatch(string2 = (String)value.getObject())) continue;
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            hashSet.add(this.frames.get(frameID3).getObject());
        }
        return hashSet;
    }

    @Override
    public Set<Reference> getReferences(Object object) {
        Value value = new Value(object);
        HashSet<Reference> hashSet = new HashSet<Reference>();
        for (FrameSlotRequest frameSlotRequest : this.valueMap.keySet()) {
            if (!this.valueMap.get(frameSlotRequest).contains(object)) continue;
            ReferenceImpl referenceImpl = new ReferenceImpl(this.getFrame(frameSlotRequest.getFrameId()), (Slot)this.getFrame(frameSlotRequest.getSlotId()), (Facet)this.getFrame(frameSlotRequest.getFacetId()), frameSlotRequest.isTemplate());
            hashSet.add(referenceImpl);
        }
        return hashSet;
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int n) {
        HashSet<Reference> hashSet = new HashSet<Reference>();
        SimpleStringMatcher simpleStringMatcher = new SimpleStringMatcher(string);
        for (FrameSlotRequest frameSlotRequest : this.valueMap.keySet()) {
            List<Value> list = this.valueMap.get(frameSlotRequest);
            boolean bl = false;
            for (Value value : list) {
                String string2;
                if (!(value.getObject() instanceof String) || !simpleStringMatcher.isMatch(string2 = (String)value.getObject())) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            ReferenceImpl referenceImpl = new ReferenceImpl(this.getFrame(frameSlotRequest.getFrameId()), this.ff.createSlot(frameSlotRequest.getSlotId(), Collections.EMPTY_LIST), frameSlotRequest.getFacetId() != null ? this.ff.createFacet(frameSlotRequest.getFacetId(), Collections.EMPTY_LIST) : null, frameSlotRequest.isTemplate());
            hashSet.add(referenceImpl);
        }
        return hashSet;
    }

    @Override
    public Set executeQuery(Query query) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void deleteFrame(Frame frame) {
        FrameValue frameValue = this.frames.get(frame.getFrameID());
        if (frameValue == null) {
            return;
        }
        this.frames.remove(frame.getFrameID());
        for (List<Value> list : this.valueMap.values()) {
            list.remove(frameValue);
        }
    }

    @Override
    public void close() {
        this.frames = new HashMap<FrameID, FrameValue>();
        this.valueMap = new HashMap<FrameSlotRequest, List<Value>>();
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        return ClosureUtils.calculateClosure(this, frame, slot, facet, bl);
    }

    @Override
    public void replaceFrame(Frame frame) {
        FrameValue frameValue = this.frames.get(frame.getFrameID());
        if (frameValue == null) {
            this.getFrameValue(frame);
        } else {
            frameValue.setFrame(frame);
        }
    }

    @Override
    public boolean beginTransaction(String string) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean commitTransaction() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean rollbackTransaction() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private class FrameValue
    extends Value {
        int javaType;
        int localFlushCount;
        Frame frame;

        public FrameValue(FrameID frameID) {
            super(frameID);
            this.javaType = 7;
            this.frame = null;
        }

        public FrameValue(Frame frame) {
            super(frame.getFrameID());
            this.javaType = 7;
            this.frame = null;
            this.localFlushCount = InMemoryFrameDbAlt.this.flushCount;
            this.frame = frame;
            this.javaType = this.determineJavaType(frame);
        }

        FrameID getFrameID() {
            return (FrameID)super.getObject();
        }

        private int determineJavaType(Frame frame) {
            if (frame instanceof Cls) {
                return 6;
            }
            if (frame instanceof Slot) {
                return 7;
            }
            if (frame instanceof Facet) {
                return 8;
            }
            if (frame instanceof SimpleInstance) {
                return 5;
            }
            throw new RuntimeException("Shouldn't be here...");
        }

        public int getJavaType() {
            return this.javaType;
        }

        public void setJavaType(int n) {
            this.javaType = n;
            this.frame = null;
        }

        public boolean cached() {
            return this.frame != null && this.localFlushCount == InMemoryFrameDbAlt.this.flushCount;
        }

        public Frame updateCache() {
            this.localFlushCount = InMemoryFrameDbAlt.this.flushCount;
            this.frame = InMemoryFrameDbAlt.this.ff.createFrameFromClassId(this.javaType, this.getFrameID());
            return this.frame;
        }

        public void setFrame(Frame frame) {
            if (this.frame == frame) {
                return;
            }
            this.javaType = this.determineJavaType(frame);
            this.frame = frame;
            this.localFlushCount = InMemoryFrameDbAlt.this.flushCount;
        }

        public Frame getObject() {
            if (this.cached()) {
                return this.frame;
            }
            return this.updateCache();
        }

        public boolean equals(Object object) {
            if (!(object instanceof FrameValue)) {
                return false;
            }
            FrameValue frameValue = (FrameValue)object;
            return this.javaType == frameValue.javaType && this.getFrameID().equals(frameValue.getFrameID());
        }

        public int hashCode() {
            return this.o.hashCode() + 13 * this.javaType;
        }

        public String toString() {
            if (this.frame != null) {
                return this.frame.toString();
            }
            return this.getFrameID().toString();
        }
    }

    private class Value {
        Object o;

        public Value(Object object) {
            this.o = object;
        }

        public Object getObject() {
            return this.o;
        }

        public boolean equals(Object object) {
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            return this.getObject().equals(((Value)object).getObject());
        }

        public int hashCode() {
            return this.o.hashCode();
        }

        public String toString() {
            return this.o.toString();
        }
    }

    private class FrameSlotRequest {
        private FrameID frameId;
        private FrameID slotId;
        private FrameID facetId;
        private boolean isTemplate;

        public FrameSlotRequest(FrameID frameID, FrameID frameID2, FrameID frameID3, boolean bl) {
            this.frameId = frameID;
            this.slotId = frameID2;
            this.facetId = frameID3;
            this.isTemplate = bl;
        }

        public FrameID getFrameId() {
            return this.frameId;
        }

        public FrameID getSlotId() {
            return this.slotId;
        }

        public FrameID getFacetId() {
            return this.facetId;
        }

        public boolean isTemplate() {
            return this.isTemplate;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FrameSlotRequest)) {
                return false;
            }
            FrameSlotRequest frameSlotRequest = (FrameSlotRequest)object;
            boolean bl = false;
            bl = this.frameId == null ? frameSlotRequest.frameId == null : this.frameId.equals(frameSlotRequest.frameId);
            boolean bl2 = false;
            bl2 = this.slotId == null ? frameSlotRequest.slotId == null : this.slotId.equals(frameSlotRequest.slotId);
            boolean bl3 = false;
            bl3 = this.facetId == null ? frameSlotRequest.facetId == null : this.facetId.equals(frameSlotRequest.facetId);
            return bl && bl2 && this.isTemplate == frameSlotRequest.isTemplate;
        }

        public int hashCode() {
            int n = 42;
            if (this.frameId != null) {
                n += this.frameId.hashCode();
            }
            if (this.slotId != null) {
                n *= this.slotId.hashCode();
            }
            if (this.facetId != null) {
                n += 84 * this.facetId.hashCode();
            }
            return n += this.isTemplate ? 22 : 5;
        }

        public String toString() {
            return "<Req: " + this.frameId + ", " + this.slotId + ", " + this.facetId + ", " + this.isTemplate + ">";
        }
    }
}

