/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.OWLSubclassPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JFileChooser;

public class ExtractTaxonomyAction
extends ResourceAction {
    private JFileChooser fileChooser;
    public static final String GROUP = "Extract/";

    public ExtractTaxonomyAction() {
        super("Extract (sub) taxonomy to text file...", Icons.getBlankIcon(), GROUP);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if (this.fileChooser.showSaveDialog(null) == 0) {
            File file = this.fileChooser.getSelectedFile();
            try {
                FileWriter fw = new FileWriter(file);
                PrintWriter pw = new PrintWriter(fw);
                ExtractTaxonomyAction.performAction((RDFSNamedClass)this.getResource(), pw);
                fw.close();
                ProtegeUI.getModalDialogFactory().showMessageDialog(this.getOWLModel(), "Taxonomy has been exported to " + file);
            }
            catch (Exception ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.getOWLModel(), "File could not be exported:\n" + ex);
            }
        }
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        return component instanceof OWLSubclassPane && resource instanceof RDFSNamedClass;
    }

    public static void performAction(RDFSNamedClass rootClass, PrintWriter pw) {
        HashSet reached = new HashSet();
        ExtractTaxonomyAction.performAction(rootClass, reached, "", pw);
    }

    public static void performAction(Cls cls, Set reached, String baseStr, PrintWriter pw) {
        reached.add(cls);
        pw.println(String.valueOf(baseStr) + cls.getBrowserText());
        baseStr = String.valueOf(baseStr) + "\t";
        for (Cls subCls : cls.getDirectSubclasses()) {
            if (!(subCls instanceof RDFSNamedClass) || !subCls.isVisible()) continue;
            if (reached.contains(subCls)) {
                pw.println(String.valueOf(baseStr) + "(" + subCls.getBrowserText() + ")...");
                continue;
            }
            ExtractTaxonomyAction.performAction(subCls, reached, baseStr, pw);
        }
    }
}

