/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.impl.FileGraphTransactionHandler;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileGraph
extends GraphMem {
    protected File name;
    protected Model model;
    protected String lang;
    protected TransactionHandler th;

    public FileGraph(File file, boolean bl, boolean bl2) {
        this(file, bl, bl2, ReificationStyle.Minimal);
    }

    public FileGraph(File file, boolean bl, boolean bl2, ReificationStyle reificationStyle) {
        super(reificationStyle);
        this.name = file;
        this.model = new ModelCom(this);
        this.lang = FileUtils.guessLang(this.name.toString());
        if (bl) {
            if (file.exists() && bl2) {
                throw new AlreadyExistsException(file.toString());
            }
        } else {
            this.readModel(this.model, bl2);
        }
    }

    protected void readModel(Model model, boolean bl) {
        this.readModelFrom(model, bl, this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readModelFrom(Model model, boolean bl, File file) {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(file);
        this.model.read(fileInputStream, "", this.lang);
        Object var7_5 = null;
        if (fileInputStream == null) return;
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (FileNotFoundException fileNotFoundException) {
                if (bl) {
                    throw new DoesNotExistException(file.toString());
                }
                Object var7_6 = null;
                if (fileInputStream == null) return;
                try {
                    fileInputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public FileGraph(String string, boolean bl) {
        this(new File(string), bl, true);
    }

    public static FileGraph create() {
        return new FileGraph(FileUtils.tempFileName("xxx", ".rdf"), true, true);
    }

    public static boolean isPlausibleGraphName(String string) {
        return FileUtils.guessLang(string, null) != null;
    }

    public void close() {
        this.saveContents(this.name);
        super.close();
    }

    public void delete() {
        this.name.delete();
    }

    protected void saveContents(File file) {
        try {
            File file2 = new File(file.getPath() + ".new");
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            this.model.write(fileOutputStream, this.lang);
            fileOutputStream.close();
            this.updateFrom(file, file2);
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    protected void updateFrom(File file, File file2) {
        if (!file2.renameTo(file)) {
            if (file.exists()) {
                this.mustDelete(file);
            }
            this.mustRename(file2, file);
        }
    }

    protected void mustDelete(File file) {
        if (!file.delete()) {
            throw new JenaException("could not delete " + file);
        }
    }

    protected void mustRename(File file, File file2) {
        if (!file.renameTo(file2)) {
            throw new JenaException("could not rename " + file + " to " + file2);
        }
    }

    public TransactionHandler getTransactionHandler() {
        if (this.th == null) {
            this.th = new FileGraphTransactionHandler(this);
        }
        return this.th;
    }
}

