/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprBoolean;
import com.hp.hpl.jena.rdql.parser.ExprNode;
import com.hp.hpl.jena.rdql.parser.NodeValue;
import com.hp.hpl.jena.rdql.parser.NodeValueSettable;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.WorkingVar;
import java.io.PrintWriter;

public class Q_StringLangEqual
extends ExprNode
implements Expr,
ExprBoolean {
    Expr left;
    Expr right;
    protected static String printName = "lang=";
    protected static String opSymbol = "langeq";

    Q_StringLangEqual(int n) {
        super(n);
    }

    Q_StringLangEqual(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    protected boolean rawEval(NodeValue nodeValue, NodeValue nodeValue2) {
        if (nodeValue.isNode() && nodeValue.getNode().isLiteral() && nodeValue2.isNode() && nodeValue2.getNode().isLiteral()) {
            Node node = nodeValue.getNode();
            Node node2 = nodeValue2.getNode();
            String string = node.getLiteral().language().toUpperCase();
            String string2 = node2.getLiteral().getLexicalForm().toUpperCase();
            if (string2.indexOf("-") >= 0) {
                return string.equals(string2);
            }
            int n = string.indexOf("-");
            if (n > 0) {
                string = string.substring(0, n);
            }
            return string.equals(string2);
        }
        return false;
    }

    public NodeValue eval(Query query, IndexValues indexValues) {
        NodeValue nodeValue = this.left.eval(query, indexValues);
        NodeValue nodeValue2 = this.right.eval(query, indexValues);
        boolean bl = this.rawEval(nodeValue, nodeValue2);
        NodeValueSettable nodeValueSettable = nodeValue instanceof NodeValueSettable ? (NodeValueSettable)nodeValue : (nodeValue2 instanceof NodeValueSettable ? (NodeValueSettable)nodeValue2 : new WorkingVar());
        nodeValueSettable.setBoolean(bl);
        return nodeValueSettable;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_StringLangEqual: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return this.getClass().getName();
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int n) {
        if (n == 0 && this.left instanceof Expression) {
            return (Expression)((Object)this.left);
        }
        if (n == 1 && this.right instanceof Expression) {
            return (Expression)((Object)this.right);
        }
        return null;
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString2(this.left, this.right, printName, opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.left, this.right, printName, opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryPrintUtils.print(printWriter, this.left, this.right, printName, opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

