/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.LocationMappingVocab;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocationMapper {
    static Log log = LogFactory.getLog((Class)LocationMapper.class);
    public static final String DEFAULT_PATH = "file:location-mapping.rdf;file:location-mapping.n3;file:etc/location-mapping.rdf;file:etc/location-mapping.n3;";
    public static final String GlobalMapperSystemProperty1 = "http://jena.hpl.hp.com/2004/08/LocationMap";
    public static final String GlobalMapperSystemProperty2 = "LocationMap";
    static String s_globalMapperPath = null;
    Map altLocations = new HashMap();
    Map altPrefixes = new HashMap();
    static LocationMapper theMapper = null;

    public static LocationMapper get() {
        if (theMapper == null) {
            theMapper = new LocationMapper();
            if (LocationMapper.getGlobalConfigPath() != null) {
                theMapper.initFromPath(LocationMapper.getGlobalConfigPath(), false);
            }
        }
        return theMapper;
    }

    public LocationMapper() {
    }

    public LocationMapper(Model model) {
        this.processConfig(model);
    }

    public LocationMapper(String string) {
        this.initFromPath(string, true);
    }

    private void initFromPath(String string, boolean bl) {
        if (string == null) {
            log.warn((Object)"Null configuration");
            return;
        }
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile();
        fileManager.addLocatorClassLoader(fileManager.getClass().getClassLoader());
        try {
            String string2;
            String string3 = null;
            InputStream inputStream = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                inputStream = fileManager.openNoMap(string2);
                if (inputStream == null) continue;
                string3 = string2;
                break;
            }
            if (inputStream == null) {
                if (!bl) {
                    log.debug((Object)("Failed to find configuration: " + string));
                }
                return;
            }
            string2 = FileUtils.guessLang(string3);
            Model model = ModelFactory.createDefaultModel();
            model.read(inputStream, null, string2);
            this.processConfig(model);
        }
        catch (JenaException jenaException) {
            LogFactory.getLog((Class)LocationMapper.class).warn((Object)("Error in configuration file: " + jenaException.getMessage()));
        }
    }

    public String altMapping(String string) {
        return this.altMapping(string, string);
    }

    public String altMapping(String string, String string2) {
        if (this.altLocations.containsKey(string)) {
            return (String)this.altLocations.get(string);
        }
        String string3 = null;
        String string4 = null;
        Iterator iterator = this.altPrefixes.keySet().iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            if (!string.startsWith(string5)) continue;
            String string6 = (String)this.altPrefixes.get(string5);
            if (string3 != null && string3.length() >= string6.length()) continue;
            string4 = string5;
            string3 = string6;
        }
        if (string3 != null) {
            return string3 + string.substring(string4.length());
        }
        return string2;
    }

    public void addAltEntry(String string, String string2) {
        this.altLocations.put(string, string2);
    }

    public void addAltPrefix(String string, String string2) {
        this.altPrefixes.put(string, string2);
    }

    public Iterator listAltEntries() {
        return this.altLocations.keySet().iterator();
    }

    public Iterator listAltPrefixes() {
        return this.altPrefixes.keySet().iterator();
    }

    public void removeAltEntry(String string) {
        this.altLocations.remove(string);
    }

    public void removeAltPrefix(String string) {
        this.altPrefixes.remove(string);
    }

    public String getAltEntry(String string) {
        return (String)this.altLocations.get(string);
    }

    public String getAltPrefix(String string) {
        return (String)this.altPrefixes.get(string);
    }

    private static String getGlobalConfigPath() {
        if (s_globalMapperPath == null) {
            s_globalMapperPath = JenaRuntime.getSystemProperty(GlobalMapperSystemProperty1, null);
        }
        if (s_globalMapperPath == null) {
            s_globalMapperPath = JenaRuntime.getSystemProperty(GlobalMapperSystemProperty2, null);
        }
        if (s_globalMapperPath == null) {
            s_globalMapperPath = DEFAULT_PATH;
        }
        return s_globalMapperPath;
    }

    public String toString() {
        String string;
        String string2;
        String string3 = "";
        Iterator iterator = this.altLocations.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = (String)this.altLocations.get(string2);
            string3 = string3 + "(Loc:" + string2 + "=>" + string + ") ";
        }
        iterator = this.altPrefixes.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = (String)this.altLocations.get(string2);
            string3 = string3 + "(Prefix:" + string2 + "=>" + string + ") ";
        }
        return string3;
    }

    private void processConfig(Model model) {
        StmtIterator stmtIterator = model.listStatements(null, LocationMappingVocab.mapping, (RDFNode)null);
        while (stmtIterator.hasNext()) {
            String string;
            String string2;
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getResource();
            if (resource.hasProperty(LocationMappingVocab.name)) {
                try {
                    string2 = resource.getRequiredProperty(LocationMappingVocab.name).getString();
                    string = resource.getRequiredProperty(LocationMappingVocab.altName).getString();
                    this.addAltEntry(string2, string);
                    log.debug((Object)("Mapping: " + string2 + " => " + string));
                }
                catch (JenaException jenaException) {
                    log.warn((Object)("Error processing name mapping: " + jenaException.getMessage()));
                    return;
                }
            }
            if (!resource.hasProperty(LocationMappingVocab.prefix)) continue;
            try {
                string2 = resource.getRequiredProperty(LocationMappingVocab.prefix).getString();
                string = resource.getRequiredProperty(LocationMappingVocab.altPrefix).getString();
                this.addAltPrefix(string2, string);
                log.debug((Object)("Prefix mapping: " + string2 + " => " + string));
            }
            catch (JenaException jenaException) {
                log.warn((Object)("Error processing prefix mapping: " + jenaException.getMessage()));
                return;
            }
        }
    }
}

