/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.vocabulary.test;

import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestVocabRDF
extends ModelTestBase {
    static final String RDFns = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

    public TestVocabRDF(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestVocabRDF.class);
    }

    public void testRDFVocabulary() {
        String string = RDFns;
        TestVocabRDF.assertEquals((String)string, (String)RDF.getURI());
        TestVocabRDF.assertEquals((String)(string + "Alt"), (String)RDF.Alt.getURI());
        TestVocabRDF.assertEquals((String)(string + "Bag"), (String)RDF.Bag.getURI());
        TestVocabRDF.assertEquals((String)(string + "Property"), (String)RDF.Property.getURI());
        TestVocabRDF.assertEquals((String)(string + "Seq"), (String)RDF.Seq.getURI());
        TestVocabRDF.assertEquals((String)(string + "Statement"), (String)RDF.Statement.getURI());
        TestVocabRDF.assertEquals((String)(string + "List"), (String)RDF.List.getURI());
        TestVocabRDF.assertEquals((String)(string + "nil"), (String)RDF.nil.getURI());
        TestVocabRDF.assertEquals((String)(string + "type"), (String)RDF.type.getURI());
        TestVocabRDF.assertEquals((String)(string + "rest"), (String)RDF.rest.getURI());
        TestVocabRDF.assertEquals((String)(string + "first"), (String)RDF.first.getURI());
        TestVocabRDF.assertEquals((String)(string + "subject"), (String)RDF.subject.getURI());
        TestVocabRDF.assertEquals((String)(string + "predicate"), (String)RDF.predicate.getURI());
        TestVocabRDF.assertEquals((String)(string + "object"), (String)RDF.object.getURI());
        TestVocabRDF.assertEquals((String)(string + "value"), (String)RDF.value.getURI());
    }

    public void testLI() {
        String string = RDFns;
        TestVocabRDF.assertEquals((String)(string + "_1"), (String)RDF.li(1).getURI());
        TestVocabRDF.assertEquals((String)(string + "_1"), (String)RDF.li(1).getURI());
        TestVocabRDF.assertEquals((String)(string + "_10"), (String)RDF.li(10).getURI());
        TestVocabRDF.assertEquals((String)(string + "_11"), (String)RDF.li(11).getURI());
        TestVocabRDF.assertEquals((String)(string + "_100"), (String)RDF.li(100).getURI());
        TestVocabRDF.assertEquals((String)(string + "_123"), (String)RDF.li(123).getURI());
        TestVocabRDF.assertEquals((String)(string + "_32768"), (String)RDF.li(32768).getURI());
    }

    public void testNodes() {
        TestVocabRDF.assertEquals((Object)RDF.Alt.getNode(), (Object)RDF.Nodes.Alt);
        TestVocabRDF.assertEquals((Object)RDF.Bag.getNode(), (Object)RDF.Nodes.Bag);
        TestVocabRDF.assertEquals((Object)RDF.Property.getNode(), (Object)RDF.Nodes.Property);
        TestVocabRDF.assertEquals((Object)RDF.Seq.getNode(), (Object)RDF.Nodes.Seq);
        TestVocabRDF.assertEquals((Object)RDF.Statement.getNode(), (Object)RDF.Nodes.Statement);
        TestVocabRDF.assertEquals((Object)RDF.List.getNode(), (Object)RDF.Nodes.List);
        TestVocabRDF.assertEquals((Object)RDF.nil.getNode(), (Object)RDF.Nodes.nil);
        TestVocabRDF.assertEquals((Object)RDF.type.getNode(), (Object)RDF.Nodes.type);
        TestVocabRDF.assertEquals((Object)RDF.rest.getNode(), (Object)RDF.Nodes.rest);
        TestVocabRDF.assertEquals((Object)RDF.first.getNode(), (Object)RDF.Nodes.first);
        TestVocabRDF.assertEquals((Object)RDF.subject.getNode(), (Object)RDF.Nodes.subject);
        TestVocabRDF.assertEquals((Object)RDF.predicate.getNode(), (Object)RDF.Nodes.predicate);
        TestVocabRDF.assertEquals((Object)RDF.object.getNode(), (Object)RDF.Nodes.object);
        TestVocabRDF.assertEquals((Object)RDF.value.getNode(), (Object)RDF.Nodes.value);
    }
}

