/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.graph.test.GraphTestBase;

public abstract class AbstractTestTripleStore
extends GraphTestBase {
    protected TripleStore store;

    public AbstractTestTripleStore(String string) {
        super(string);
    }

    public abstract TripleStore getTripleStore();

    public void setUp() {
        this.store = this.getTripleStore();
    }

    public void testEmpty() {
        this.testEmpty(this.store);
    }

    public void testAddOne() {
        this.store.add(AbstractTestTripleStore.triple("x P y"));
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)this.store.isEmpty());
        AbstractTestTripleStore.assertEquals((int)1, (int)this.store.size());
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("x P y")));
        AbstractTestTripleStore.assertEquals((Object)this.nodeSet("x"), (Object)AbstractTestTripleStore.iteratorToSet(this.store.listSubjects()));
        AbstractTestTripleStore.assertEquals((Object)this.nodeSet("y"), (Object)AbstractTestTripleStore.iteratorToSet(this.store.listObjects()));
        AbstractTestTripleStore.assertEquals((Object)AbstractTestTripleStore.tripleSet("x P y"), (Object)AbstractTestTripleStore.iteratorToSet(this.store.find(AbstractTestTripleStore.triple("?? ?? ??"))));
    }

    public void testListSubjects() {
        this.someStatements(this.store);
        AbstractTestTripleStore.assertEquals((Object)this.nodeSet("a x _z r q"), (Object)AbstractTestTripleStore.iteratorToSet(this.store.listSubjects()));
    }

    public void testListObjects() {
        this.someStatements(this.store);
        AbstractTestTripleStore.assertEquals((Object)this.nodeSet("b y i _j _t 17"), (Object)AbstractTestTripleStore.iteratorToSet(this.store.listObjects()));
    }

    public void testContains() {
        this.someStatements(this.store);
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("a P b")));
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("x P y")));
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("a P i")));
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("_z Q _j")));
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("x R y")));
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("r S _t")));
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("q R 17")));
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)this.store.contains(AbstractTestTripleStore.triple("a P x")));
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)this.store.contains(AbstractTestTripleStore.triple("a P _j")));
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)this.store.contains(AbstractTestTripleStore.triple("b Z r")));
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)this.store.contains(AbstractTestTripleStore.triple("_a P x")));
    }

    public void testFind() {
        this.someStatements(this.store);
        AbstractTestTripleStore.assertEquals((Object)AbstractTestTripleStore.tripleSet(""), (Object)AbstractTestTripleStore.iteratorToSet(this.store.find(AbstractTestTripleStore.triple("no such thing"))));
        AbstractTestTripleStore.assertEquals((Object)AbstractTestTripleStore.tripleSet("a P b; a P i"), (Object)AbstractTestTripleStore.iteratorToSet(this.store.find(AbstractTestTripleStore.triple("a P ??"))));
        AbstractTestTripleStore.assertEquals((Object)AbstractTestTripleStore.tripleSet("a P b; x P y; a P i"), (Object)AbstractTestTripleStore.iteratorToSet(this.store.find(AbstractTestTripleStore.triple("?? P ??"))));
        AbstractTestTripleStore.assertEquals((Object)AbstractTestTripleStore.tripleSet("x P y; x R y"), (Object)AbstractTestTripleStore.iteratorToSet(this.store.find(AbstractTestTripleStore.triple("x ?? y"))));
        AbstractTestTripleStore.assertEquals((Object)AbstractTestTripleStore.tripleSet("_z Q _j"), (Object)AbstractTestTripleStore.iteratorToSet(this.store.find(AbstractTestTripleStore.triple("?? ?? _j"))));
        AbstractTestTripleStore.assertEquals((Object)AbstractTestTripleStore.tripleSet("q R 17"), (Object)AbstractTestTripleStore.iteratorToSet(this.store.find(AbstractTestTripleStore.triple("?? ?? 17"))));
    }

    public void testRemove() {
        this.store.add(AbstractTestTripleStore.triple("nothing before ace"));
        this.store.add(AbstractTestTripleStore.triple("ace before king"));
        this.store.add(AbstractTestTripleStore.triple("king before queen"));
        this.store.delete(AbstractTestTripleStore.triple("ace before king"));
        AbstractTestTripleStore.assertEquals((Object)AbstractTestTripleStore.tripleSet("king before queen; nothing before ace"), (Object)AbstractTestTripleStore.iteratorToSet(this.store.find(AbstractTestTripleStore.triple("?? ?? ??"))));
        this.store.delete(AbstractTestTripleStore.triple("king before queen"));
        AbstractTestTripleStore.assertEquals((Object)AbstractTestTripleStore.tripleSet("nothing before ace"), (Object)AbstractTestTripleStore.iteratorToSet(this.store.find(AbstractTestTripleStore.triple("?? ?? ??"))));
    }

    public void someStatements(TripleStore tripleStore) {
        tripleStore.add(AbstractTestTripleStore.triple("a P b"));
        tripleStore.add(AbstractTestTripleStore.triple("x P y"));
        tripleStore.add(AbstractTestTripleStore.triple("a P i"));
        tripleStore.add(AbstractTestTripleStore.triple("_z Q _j"));
        tripleStore.add(AbstractTestTripleStore.triple("x R y"));
        tripleStore.add(AbstractTestTripleStore.triple("r S _t"));
        tripleStore.add(AbstractTestTripleStore.triple("q R 17"));
    }

    public void testEmpty(TripleStore tripleStore) {
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)tripleStore.isEmpty());
        AbstractTestTripleStore.assertEquals((int)0, (int)tripleStore.size());
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)tripleStore.find(AbstractTestTripleStore.triple("?? ?? ??")).hasNext());
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)tripleStore.listObjects().hasNext());
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)tripleStore.listSubjects().hasNext());
        AbstractTestTripleStore.assertFalse((boolean)tripleStore.contains(AbstractTestTripleStore.triple("x P y")));
    }
}

