/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.compact;

import com.hp.hpl.jena.ontology.OntClass;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.XSPNames;
import edu.stanford.smi.protegex.owl.model.classparser.DatatypeNameChecker;
import edu.stanford.smi.protegex.owl.model.classparser.compact.CompactParserConstants;
import edu.stanford.smi.protegex.owl.model.classparser.compact.CompactParserTokenManager;
import edu.stanford.smi.protegex.owl.model.classparser.compact.CompactParserUtil;
import edu.stanford.smi.protegex.owl.model.classparser.compact.JavaCharStream;
import edu.stanford.smi.protegex.owl.model.classparser.compact.ParseException;
import edu.stanford.smi.protegex.owl.model.classparser.compact.Token;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

class CompactParser
implements CompactParserConstants {
    public static boolean nextCouldBeCls;
    public static boolean nextCouldBeInstance;
    public static boolean nextCouldBeSlot;
    public static boolean nextCouldBeDatatypeName;
    public static RDFProperty recentHasValueProperty;
    public static String errorMessage;
    public static DatatypeNameChecker datatypeNameChecker;
    private OWLModel owlModel;
    private boolean create;
    public CompactParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[17];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static {
        CompactParser.jj_la1_0();
        CompactParser.jj_la1_1();
    }

    public static DatatypeNameChecker getDatatypeNameChecker() {
        return datatypeNameChecker;
    }

    public static void checkClass(OWLModel owlModel, String text) throws ParseException {
        CompactParser.reset();
        datatypeNameChecker = new DatatypeNameChecker(owlModel);
        text = CompactParserUtil.getParseableString(text);
        CompactParser parser = new CompactParser(new StringReader(text));
        parser.owlModel = owlModel;
        parser.create = false;
        parser.parseFile();
    }

    private void checkFeatureSupported(OntClass ontClass) throws ParseException {
        if (!ProfilesManager.isFeatureSupported(this.owlModel, ontClass)) {
            String label = ontClass.getLabel(null);
            if (label == null) {
                label = ontClass.getLocalName();
            }
            errorMessage = "Feature \"" + label + "\" unavailable in current language profile";
            throw this.generateParseException();
        }
    }

    public static void checkHasValueFiller(OWLModel owlModel, String text) throws ParseException {
        CompactParser.reset();
        datatypeNameChecker = new DatatypeNameChecker(owlModel);
        text = CompactParserUtil.getParseableString(text);
        CompactParser parser = new CompactParser(new StringReader(text));
        parser.owlModel = owlModel;
        parser.create = false;
        parser.OWLHasValueValue();
    }

    public static void checkQuantifierFiller(OWLModel owlModel, String text) throws ParseException {
        CompactParser.reset();
        datatypeNameChecker = new DatatypeNameChecker(owlModel);
        text = CompactParserUtil.getParseableString(text);
        CompactParser parser = new CompactParser(new StringReader(text));
        parser.owlModel = owlModel;
        parser.create = false;
        if (parser.DataType() == null) {
            throw new ParseException("Unknown datatype \"" + text + "\".");
        }
    }

    public static RDFSClass parseClass(OWLModel owlModel, String text) throws ParseException {
        CompactParser.reset();
        datatypeNameChecker = new DatatypeNameChecker(owlModel);
        text = CompactParserUtil.getParseableString(text);
        CompactParser parser = new CompactParser(new StringReader(text));
        parser.owlModel = owlModel;
        parser.create = true;
        return parser.parseFile();
    }

    public static Object parseHasValueFiller(OWLModel owlModel, String text) throws ParseException {
        CompactParser.reset();
        datatypeNameChecker = new DatatypeNameChecker(owlModel);
        CompactParser parser = new CompactParser(new StringReader(text));
        parser.owlModel = owlModel;
        parser.create = true;
        return parser.OWLHasValueValue();
    }

    public static Object parseQuantifierFiller(OWLModel owlModel, String text) throws ParseException {
        CompactParser.reset();
        datatypeNameChecker = new DatatypeNameChecker(owlModel);
        text = CompactParserUtil.getParseableString(text);
        CompactParser parser = new CompactParser(new StringReader(text));
        parser.owlModel = owlModel;
        parser.create = false;
        return parser.DataType();
    }

    private static void reset() {
        nextCouldBeCls = false;
        nextCouldBeSlot = false;
        nextCouldBeInstance = false;
        nextCouldBeDatatypeName = false;
        errorMessage = null;
    }

    public final RDFSClass parseFile() throws ParseException {
        RDFSClass result = this.OWLUnionClass();
        this.jj_consume_token(0);
        return result;
    }

    public final RDFSClass OWLUnionClass() throws ParseException {
        ArrayList<RDFSClass> clses = new ArrayList<RDFSClass>();
        RDFSClass cls = this.OWLIntersectionClass();
        clses.add(cls);
        while (this.jj_2_1(2)) {
            this.jj_consume_token(27);
            cls = this.OWLIntersectionClass();
            clses.add(cls);
        }
        if (clses.size() == 1) {
            return cls;
        }
        this.checkFeatureSupported(OWLProfiles.Union_Classes);
        if (this.create) {
            return this.owlModel.createOWLUnionClass(clses);
        }
        return null;
    }

    public final RDFSClass OWLIntersectionClass() throws ParseException {
        ArrayList<RDFSClass> clses = new ArrayList<RDFSClass>();
        RDFSClass cls = this.OWLComplementClass();
        clses.add(cls);
        while (this.jj_2_2(2)) {
            this.jj_consume_token(28);
            cls = this.OWLComplementClass();
            clses.add(cls);
        }
        if (clses.size() == 1) {
            return cls;
        }
        if (this.create) {
            return this.owlModel.createOWLIntersectionClass(clses);
        }
        return null;
    }

    public final RDFSClass OWLComplementClass() throws ParseException {
        RDFSClass cls;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                RDFSClass cls2 = this.OWLRestrictionOrNamedClass();
                this.checkFeatureSupported(OWLProfiles.Complement_Classes);
                if (this.create) {
                    return this.owlModel.createOWLComplementClass(cls2);
                }
                return null;
            }
            case 6: 
            case 23: 
            case 34: {
                cls = this.OWLRestrictionOrNamedClass();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return cls;
    }

    public final RDFSClass OWLRestrictionOrNamedClass() throws ParseException {
        RDFSClass cls;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                cls = this.OWLEnumeratedClass();
                break;
            }
            case 23: {
                cls = this.IDClass();
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                cls = this.OWLUnionClass();
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return cls;
    }

    public final RDFSClass IDClass() throws ParseException {
        String id = this.Identifier();
        Frame frame = this.owlModel.getFrame(id);
        if (frame instanceof RDFSClass) {
            return (RDFSClass)frame;
        }
        if (frame instanceof RDFProperty && !((RDFProperty)frame).isAnnotationProperty()) {
            recentHasValueProperty = (RDFProperty)frame;
            return this.Restriction(recentHasValueProperty);
        }
        nextCouldBeCls = true;
        nextCouldBeSlot = true;
        errorMessage = "Class or property name expected";
        throw this.generateParseException();
    }

    public final OWLRestriction Restriction(RDFProperty property) throws ParseException {
        OWLRestriction result;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: 
            case 31: 
            case 32: {
                result = this.OWLCardinalityBase(property);
                break;
            }
            case 33: {
                result = this.OWLHasValue(property);
                break;
            }
            case 36: {
                result = this.OWLAllValuesFrom(property);
                break;
            }
            case 37: {
                result = this.OWLSomeValuesFrom(property);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final OWLCardinalityBase OWLCardinalityBase(RDFProperty property) throws ParseException {
        OWLCardinalityBase result;
        RDFSClass valuesFromClass = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                result = this.OWLMaxCardinality(property);
                break;
            }
            case 31: {
                result = this.OWLMinCardinality(property);
                break;
            }
            case 32: {
                result = this.OWLCardinality(property);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 23: 
            case 29: 
            case 34: {
                valuesFromClass = this.OWLUnionClass();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        if (this.create && valuesFromClass != null) {
            result.setValuesFrom(valuesFromClass);
        }
        return result;
    }

    public final OWLMaxCardinality OWLMaxCardinality(RDFProperty slot) throws ParseException {
        this.jj_consume_token(30);
        int card = this.CardinalityValue();
        this.checkFeatureSupported(OWLProfiles.MaxCardinality_Restrictions);
        if (this.create) {
            return this.owlModel.createOWLMaxCardinality(slot, card);
        }
        return null;
    }

    public final OWLMinCardinality OWLMinCardinality(RDFProperty slot) throws ParseException {
        this.jj_consume_token(31);
        int card = this.CardinalityValue();
        this.checkFeatureSupported(OWLProfiles.MinCardinality_Restrictions);
        if (this.create) {
            return this.owlModel.createOWLMinCardinality(slot, card);
        }
        return null;
    }

    public final OWLCardinality OWLCardinality(RDFProperty slot) throws ParseException {
        this.jj_consume_token(32);
        int card = this.CardinalityValue();
        this.checkFeatureSupported(OWLProfiles.MinCardinality_Restrictions);
        this.checkFeatureSupported(OWLProfiles.MaxCardinality_Restrictions);
        if (this.create) {
            return this.owlModel.createOWLCardinality(slot, card);
        }
        return null;
    }

    public final OWLHasValue OWLHasValue(RDFProperty slot) throws ParseException {
        this.jj_consume_token(33);
        Object value = this.OWLHasValueValue();
        this.checkFeatureSupported(OWLProfiles.HasValue_Restrictions);
        if (!(slot instanceof OWLDatatypeProperty)) {
            if (OWLUtil.hasOWLDLProfile(this.owlModel) && (value instanceof Cls || value instanceof Slot)) {
                value = null;
            }
            if (!(value instanceof Instance)) {
                nextCouldBeInstance = true;
                if (OWLUtil.hasOWLFullProfile(this.owlModel)) {
                    nextCouldBeSlot = true;
                    nextCouldBeCls = true;
                    errorMessage = "Individual, class or property expected";
                } else {
                    errorMessage = "Individual expected (in OWL DL)";
                }
                throw this.generateParseException();
            }
        } else if (slot instanceof OWLDatatypeProperty && value instanceof Instance) {
            errorMessage = "Datatype literal expected";
            throw this.generateParseException();
        }
        if (this.create) {
            return this.owlModel.createOWLHasValue(slot, value);
        }
        return null;
    }

    public final Object OWLHasValueValueAndEOF() throws ParseException {
        Object result = this.OWLHasValueValue();
        this.jj_consume_token(0);
        return result;
    }

    public final Object OWLHasValueValue() throws ParseException {
        Object result;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                result = this.OWLHasValueValueString();
                break;
            }
            case 19: {
                result = this.OWLHasValueValueFloat();
                break;
            }
            case 18: {
                result = this.OWLHasValueValueInteger();
                break;
            }
            case 23: {
                result = this.OWLHasValueValueBooleanOrInstance();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final String OWLHasValueValueString() throws ParseException {
        Token token = this.jj_consume_token(21);
        String str = token.image;
        int len = str.length();
        return str.substring(1, len - 1);
    }

    public final Float OWLHasValueValueFloat() throws ParseException {
        Token token = this.jj_consume_token(19);
        return Float.valueOf(token.image);
    }

    public final Integer OWLHasValueValueInteger() throws ParseException {
        Token token = this.jj_consume_token(18);
        return Integer.valueOf(token.image);
    }

    public final Object OWLHasValueValueBooleanOrInstance() throws ParseException {
        String id = this.Identifier();
        if (id.equals("true")) {
            return Boolean.TRUE;
        }
        if (id.equals("false")) {
            return Boolean.FALSE;
        }
        RDFResource instance = this.owlModel.getRDFResourceByNameOrBrowserText(id);
        if (instance == null) {
            nextCouldBeInstance = true;
            nextCouldBeSlot = true;
            nextCouldBeCls = true;
            errorMessage = "Instance or datatype literal expected";
            throw this.generateParseException();
        }
        return instance;
    }

    public final int CardinalityValue() throws ParseException {
        Token token = this.jj_consume_token(18);
        int value = Integer.parseInt(token.image);
        if (value >= 0) {
            return value;
        }
        throw this.generateParseException();
    }

    public final String Identifier() throws ParseException {
        Token t = this.jj_consume_token(23);
        return t.image;
    }

    public final RDFSClass OWLEnumeratedClass() throws ParseException {
        ArrayList<RDFResource> values = new ArrayList<RDFResource>();
        this.jj_consume_token(34);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block3;
                }
            }
            String instanceText = this.Identifier();
            RDFResource instance = this.owlModel.getRDFResourceByNameOrBrowserText(instanceText);
            if (OWLUtil.hasOWLDLProfile(this.owlModel) && (instance instanceof Cls || instance instanceof Slot)) {
                instance = null;
            }
            if (instance == null) {
                nextCouldBeInstance = true;
                if (OWLUtil.hasOWLFullProfile(this.owlModel)) {
                    nextCouldBeCls = true;
                    nextCouldBeSlot = true;
                    errorMessage = "Name of an individual, class or property expected";
                } else {
                    errorMessage = "Name of an individual expected (in OWL DL)";
                }
                throw this.generateParseException();
            }
            values.add(instance);
        }
        this.jj_consume_token(35);
        this.checkFeatureSupported(OWLProfiles.Enumerated_Classes);
        if (this.create) {
            return this.owlModel.createOWLEnumeratedClass(values);
        }
        return null;
    }

    public final OWLAllValuesFrom OWLAllValuesFrom(RDFProperty property) throws ParseException {
        this.jj_consume_token(36);
        this.checkFeatureSupported(OWLProfiles.AllValuesFrom_Restrictions);
        Object valueType = this.DataType();
        if (valueType instanceof RDFSClass || valueType == ValueType.INSTANCE) {
            if (property instanceof OWLDatatypeProperty) {
                errorMessage = "owl:ObjectProperty or rdf:Property expected";
                throw this.generateParseException();
            }
            if (this.create) {
                return this.owlModel.createOWLAllValuesFrom(property, (RDFSClass)valueType);
            }
            return null;
        }
        if (valueType == null) {
            errorMessage = "XML Schema datatype expected";
            throw this.generateParseException();
        }
        if (!(property instanceof OWLDatatypeProperty)) {
            errorMessage = "owl:DatatypeProperty expected";
            throw this.generateParseException();
        }
        if (this.create) {
            if (valueType instanceof RDFSDatatype) {
                return this.owlModel.createOWLAllValuesFrom(property, (RDFSDatatype)valueType);
            }
            return this.owlModel.createOWLAllValuesFrom(property, (RDFSLiteral[])valueType);
        }
        return null;
    }

    public final OWLSomeValuesFrom OWLSomeValuesFrom(RDFProperty property) throws ParseException {
        this.jj_consume_token(37);
        this.checkFeatureSupported(OWLProfiles.SomeValuesFrom_Restrictions);
        Object valueType = this.DataType();
        if (valueType instanceof RDFSClass || valueType == ValueType.INSTANCE) {
            if (property instanceof OWLDatatypeProperty) {
                errorMessage = "owl:ObjectProperty or rdf:Property expected";
                throw this.generateParseException();
            }
            if (this.create) {
                return this.owlModel.createOWLSomeValuesFrom(property, (RDFSClass)valueType);
            }
            return null;
        }
        if (!(property instanceof OWLDatatypeProperty)) {
            errorMessage = "owl:DatatypeProperty expected";
            throw this.generateParseException();
        }
        if (valueType == null) {
            errorMessage = "XML Schema datatype expected";
            throw this.generateParseException();
        }
        if (this.create) {
            if (valueType instanceof RDFSDatatype) {
                return this.owlModel.createOWLSomeValuesFrom(property, (RDFSDatatype)valueType);
            }
            return this.owlModel.createOWLSomeValuesFrom(property, (RDFSLiteral[])valueType);
        }
        return null;
    }

    public final Object DataType() throws ParseException {
        RDFSLiteral[] oneOfValues = null;
        RDFSClass cl = null;
        boolean userDerived = false;
        RDFProperty minProp = null;
        RDFProperty maxProp = null;
        String minVal = null;
        String maxVal = null;
        nextCouldBeDatatypeName = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                oneOfValues = this.OneOfValues();
                return oneOfValues;
            }
            case 24: {
                this.token = this.jj_consume_token(24);
                String qName = datatypeNameChecker.getDatatypeQName(this.token.image);
                RDFSDatatype datatype = this.owlModel.getRDFSDatatypeByName(qName);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: 
                    case 8: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                this.token = this.jj_consume_token(6);
                                minProp = XSPNames.getRDFProperty(this.owlModel, 3);
                                break;
                            }
                            case 8: {
                                this.token = this.jj_consume_token(8);
                                minProp = XSPNames.getRDFProperty(this.owlModel, 4);
                                break;
                            }
                            default: {
                                this.jj_la1[7] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        block12 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: 
                            case 18: 
                            case 19: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 18: {
                                        this.token = this.jj_consume_token(18);
                                        minVal = this.token.image;
                                        break block12;
                                    }
                                    case 19: {
                                        this.token = this.jj_consume_token(19);
                                        minVal = this.token.image;
                                        break block12;
                                    }
                                    case 10: {
                                        this.jj_consume_token(10);
                                        break block12;
                                    }
                                }
                                this.jj_la1[8] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[9] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(38);
                        block20 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: 
                            case 18: 
                            case 19: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 18: {
                                        this.token = this.jj_consume_token(18);
                                        maxVal = this.token.image;
                                        break block20;
                                    }
                                    case 19: {
                                        this.token = this.jj_consume_token(19);
                                        maxVal = this.token.image;
                                        break block20;
                                    }
                                    case 10: {
                                        this.jj_consume_token(10);
                                        break block20;
                                    }
                                }
                                this.jj_la1[10] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[11] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                this.token = this.jj_consume_token(7);
                                maxProp = XSPNames.getRDFProperty(this.owlModel, 5);
                                break;
                            }
                            case 9: {
                                this.token = this.jj_consume_token(9);
                                maxProp = XSPNames.getRDFProperty(this.owlModel, 6);
                                break;
                            }
                            default: {
                                this.jj_la1[12] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        userDerived = true;
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                if (!userDerived) {
                    return datatype;
                }
                if (this.create) {
                    RDFSDatatype udd = this.owlModel.createRDFSDatatype(this.owlModel.getNextAnonymousResourceName());
                    udd.setPropertyValue(XSPNames.getRDFProperty(this.owlModel, 0), datatype);
                    if (minProp != null && minVal != null) {
                        udd.setPropertyValue(minProp, this.owlModel.createRDFSLiteral(minVal, datatype));
                    }
                    if (maxProp != null && maxVal != null) {
                        udd.setPropertyValue(maxProp, this.owlModel.createRDFSLiteral(maxVal, datatype));
                    }
                    return udd;
                }
                return datatype;
            }
            case 6: 
            case 23: 
            case 29: 
            case 34: {
                cl = this.OWLComplementClass();
                if (this.create) {
                    return cl;
                }
                return ValueType.INSTANCE;
            }
        }
        this.jj_la1[14] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final RDFSLiteral[] OneOfValues() throws ParseException {
        ArrayList<RDFSLiteral> result;
        block9: {
            result = new ArrayList<RDFSLiteral>();
            Token token = null;
            Number numberValue = null;
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: 
                    case 19: 
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        token = this.jj_consume_token(21);
                        String str = token.image;
                        int len = str.length();
                        result.add(this.owlModel.createRDFSLiteral(str.substring(1, len - 1)));
                        continue block8;
                    }
                    case 18: {
                        numberValue = this.OWLHasValueValueInteger();
                        result.add(this.owlModel.createRDFSLiteral(numberValue));
                        continue block8;
                    }
                    case 19: {
                        numberValue = this.OWLHasValueValueFloat();
                        result.add(this.owlModel.createRDFSLiteral(numberValue));
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[16] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(35);
        return result.toArray(new RDFSLiteral[0]);
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private final boolean jj_3R_11() {
        return this.jj_3R_14();
    }

    private final boolean jj_3R_10() {
        return this.jj_3R_13();
    }

    private final boolean jj_3R_13() {
        return this.jj_scan_token(34);
    }

    private final boolean jj_3R_7() {
        return this.jj_scan_token(29);
    }

    private final boolean jj_3R_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_10()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_11()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_12()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_5() {
        return this.jj_3R_6();
    }

    private final boolean jj_3R_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_8()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_3R_5();
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_3R_6();
    }

    private final boolean jj_3R_14() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_15() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_8() {
        return this.jj_3R_9();
    }

    private final boolean jj_3R_12() {
        return this.jj_scan_token(6);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{545259584, 0x800040, -1073741824, -1073741824, 545259584, 0xAC0000, 0x800000, 320, 787456, 787456, 787456, 787456, 640, 320, 566231104, 0x2C0000, 0x2C0000};
    }

    private static void jj_la1_1() {
        int[] nArray = new int[17];
        nArray[0] = 4;
        nArray[1] = 4;
        nArray[2] = 51;
        nArray[3] = 1;
        nArray[4] = 4;
        nArray[14] = 4;
        jj_la1_1 = nArray;
    }

    public CompactParser(InputStream stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new CompactParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 17) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 17) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public CompactParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new CompactParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 17) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 17) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public CompactParser(CompactParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 17) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(CompactParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 17) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[39];
        int i = 0;
        while (i < 39) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 17) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 39) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 2) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                    }
                }
            } while ((p = p.next) != null);
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

