/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.DocumentChangedListener;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InstanceNameEditor
extends JTextField {
    private DocumentChangedListener documentListener = new DocumentChangedListener(){

        public void insertUpdate(DocumentEvent event) {
            if (InstanceNameEditor.this.getText().indexOf(32) > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        InstanceNameEditor.this.replaceSpaces();
                    }
                });
            } else {
                InstanceNameEditor.this.onTextChange();
            }
        }

        public void stateChanged(ChangeEvent event) {
            InstanceNameEditor.this.onTextChange();
        }
    };
    private FrameListener frameListener = new FrameAdapter(){

        public void nameChanged(FrameEvent event) {
            InstanceNameEditor.this.updateAll();
        }

        public void deleted(FrameEvent event) {
            InstanceNameEditor.this.instance = null;
            InstanceNameEditor.this.updateAll();
        }
    };
    private Instance instance;

    public InstanceNameEditor() {
        OWLUI.addCopyPastePopup(this);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                InstanceNameEditor.this.attemptCommit();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 10: {
                        InstanceNameEditor.this.attemptCommit();
                        break;
                    }
                    case 27: {
                        InstanceNameEditor.this.updateAll();
                    }
                }
            }
        });
        this.getDocument().addDocumentListener((DocumentListener)this.documentListener);
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(size.width + 130, size.height);
    }

    public void addNotify() {
        super.addNotify();
        if (this.needsNameChange()) {
            this.selectAll();
        }
    }

    protected void attemptCommit() {
        String oldName;
        String newName;
        if (this.instance != null && !this.instance.isBeingDeleted() && this.isValidName(newName = this.getText()) && !(oldName = this.instance.getName()).equals(newName)) {
            this.instance.setName(newName);
        }
    }

    public void dispose() {
        this.removeListener();
    }

    protected Instance getInstance() {
        return this.instance;
    }

    protected String getInvalidTextDescription(String text) {
        String invalidText = null;
        if (text == null || !this.isValidName(text)) {
            invalidText = "Invalid name";
        }
        return invalidText;
    }

    public boolean isValidName(String name) {
        Instance currentFrame = this.getInstance();
        if (currentFrame != null) {
            Frame frame = currentFrame.getKnowledgeBase().getFrame(name);
            boolean isDuplicate = frame != null && !frame.equals(currentFrame);
            boolean isValid = currentFrame.getKnowledgeBase().isValidFrameName(name, (Frame)currentFrame);
            return isValid && !isDuplicate && name.length() > 0;
        }
        return true;
    }

    private boolean needsNameChange() {
        String name;
        boolean needsNameChange = false;
        Instance instance = this.getInstance();
        if (instance != null && instance.isEditable() && (name = instance.getName()) != null) {
            int index = name.lastIndexOf(95);
            String possibleIntegerString = name.substring(index + 1);
            try {
                Integer.parseInt(possibleIntegerString);
                needsNameChange = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return needsNameChange;
    }

    private void onTextChange() {
        this.validateText(this.getText());
    }

    private void removeListener() {
        if (this.instance != null) {
            this.instance.removeFrameListener(this.frameListener);
        }
    }

    private void replaceSpaces() {
        String str = this.getText();
        str = str.replace(' ', '_');
        int pos = this.getCaretPosition();
        this.setText(str);
        this.setCaretPosition(pos);
        this.onTextChange();
    }

    public void selectAll() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstanceNameEditor.super.selectAll();
                InstanceNameEditor.this.requestFocus();
            }
        });
    }

    public void setInstance(Instance instance) {
        this.attemptCommit();
        this.removeListener();
        this.instance = instance;
        if (instance != null) {
            instance.addFrameListener(this.frameListener);
        }
        this.updateAll();
    }

    public void setText(String text) {
        this.documentListener.disable();
        super.setText(text == null ? "" : text);
        this.documentListener.enable();
        this.validateText(text);
    }

    private void updateAll() {
        if (this.instance != null) {
            String name = this.instance.getName();
            this.setText(name);
            this.setEditable(this.instance.isEditable());
            this.onTextChange();
            if (this.needsNameChange()) {
                this.selectAll();
            }
        } else {
            this.setText("");
            this.setEditable(false);
        }
    }

    protected boolean validateText(String text) {
        String errorDescription;
        String string = errorDescription = text == null ? null : this.getInvalidTextDescription(text);
        if (errorDescription == null) {
            this.setForeground(Color.black);
            this.setToolTipText(null);
        } else {
            this.setForeground(Color.red);
            this.setToolTipText(errorDescription);
        }
        return errorDescription == null;
    }
}

