/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owlx.examples.javaDemo;

import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owlx.examples.javaDemo.model.Customer;
import edu.stanford.smi.protegex.owlx.examples.javaDemo.model.MyFactory;
import edu.stanford.smi.protegex.owlx.examples.javaDemo.model.Product;
import edu.stanford.smi.protegex.owlx.examples.javaDemo.model.Purchase;
import java.util.Iterator;

public class JavaDemoApplication {
    public static void main(String[] args) throws Exception {
        String uri = "http://www.owl-ontologies.com/javaDemo.owl";
        JenaOWLModel owlModel = ProtegeOWL.createJenaOWLModelFromURI(uri);
        OWLNamedClass productClass = owlModel.getOWLNamedClass("Product");
        Product productA = (Product)productClass.createOWLIndividual("ProdcutA").as(Product.class);
        productA.setPrice(41.99f);
        Product productB = (Product)productClass.createOWLIndividual("ProductB").as(Product.class);
        productB.setPrice(1.5f);
        Product productC = (Product)productClass.createOWLIndividual("ProductC").as(Product.class);
        productC.setPrice(2.5f);
        OWLNamedClass customerClass = owlModel.getOWLNamedClass("Customer");
        Customer customer = (Customer)customerClass.createOWLIndividual("Hans").as(Customer.class);
        customer.setFirstName("Hans");
        customer.setLastName("Aldi");
        JavaDemoApplication.createPurchase(customer, productA, "2005-01-01");
        JavaDemoApplication.createPurchase(customer, productB, "2005-01-02");
        JavaDemoApplication.createPurchase(customer, productC, "2005-01-03");
        JavaDemoApplication.createPurchase(customer, productA, "2005-02-07");
        double sum = customer.getPurchasesSum();
        System.out.println("Customer " + customer.getBrowserText() + " has spent $" + sum);
    }

    private static Purchase createPurchase(Customer customer, Product product, String date) {
        OWLModel owlModel = customer.getOWLModel();
        Purchase purchase = new MyFactory(owlModel).createPurchase(null);
        purchase.setCustomer(customer);
        purchase.setProduct(product);
        RDFSDatatype xsdDate = owlModel.getRDFSDatatypeByName("xsd:date");
        purchase.setDate(owlModel.createRDFSLiteral(date, xsdDate));
        return purchase;
    }

    private static float getPurchasesSum(RDFIndividual customer) {
        OWLModel owlModel = customer.getOWLModel();
        float sum = 0.0f;
        RDFProperty purchasesProperty = owlModel.getRDFProperty("purchases");
        RDFProperty productProperty = owlModel.getRDFProperty("product");
        RDFProperty priceProperty = owlModel.getRDFProperty("price");
        Iterator purchases = customer.listPropertyValues(purchasesProperty);
        while (purchases.hasNext()) {
            RDFIndividual purchase = (RDFIndividual)purchases.next();
            RDFIndividual product = (RDFIndividual)purchase.getPropertyValue(productProperty);
            Float price = (Float)product.getPropertyValue(priceProperty);
            sum += price.floatValue();
        }
        return sum;
    }
}

